package mezz.jei.fabric.events;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_465;

public class JeiScreenEvents {
    public static final Event<AfterRenderBackground> AFTER_RENDER_BACKGROUND =
        EventFactory.createArrayBacked(AfterRenderBackground.class, callbacks -> (screen, guiGraphics) -> {
            for (AfterRenderBackground callback : callbacks) {
                callback.afterRenderBackground(screen, guiGraphics);
            }
        });

    public static final Event<DrawForeground> DRAW_FOREGROUND =
        EventFactory.createArrayBacked(DrawForeground.class, callbacks -> (screen, guiGraphics, mouseX, mouseY) -> {
            for (DrawForeground callback : callbacks) {
                callback.drawForeground(screen, guiGraphics, mouseX, mouseY);
            }
        });


    @Environment(EnvType.CLIENT)
    @FunctionalInterface
    public interface AfterRenderBackground {
        void afterRenderBackground(class_437 screen, class_332 guiGraphics);
    }

    @Environment(EnvType.CLIENT)
    @FunctionalInterface
    public interface DrawForeground {
        void drawForeground(class_465<?> screen, class_332 guiGraphics, int mouseX, int mouseY);
    }
}
