package mezz.jei.library.render;

import com.mojang.blaze3d.systems.RenderSystem;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.common.platform.IPlatformRenderHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ErrorUtil;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_918;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;

public class ItemStackRenderer implements IIngredientRenderer<class_1799> {
	private static final Logger LOGGER = LogManager.getLogger();

	@Override
	public void render(class_4587 poseStack, @Nullable class_1799 ingredient) {
		if (ingredient != null) {
			RenderSystem.enableDepthTest();

			class_310 minecraft = class_310.method_1551();
			class_327 font = getFontRenderer(minecraft, ingredient);
			class_918 itemRenderer = minecraft.method_1480();
			itemRenderer.method_27953(poseStack, ingredient, 0, 0);
			itemRenderer.method_4025(poseStack, font, ingredient, 0, 0);
			RenderSystem.disableBlend();
		}
	}

	@Override
	public List<class_2561> getTooltip(class_1799 ingredient, class_1836 tooltipFlag) {
		class_310 minecraft = class_310.method_1551();
		class_1657 player = minecraft.field_1724;
		try {
			return ingredient.method_7950(player, tooltipFlag);
		} catch (RuntimeException | LinkageError e) {
			String itemStackInfo = ErrorUtil.getItemStackInfo(ingredient);
			LOGGER.error("Failed to get tooltip: {}", itemStackInfo, e);
			List<class_2561> list = new ArrayList<>();
			class_5250 crash = class_2561.method_43471("jei.tooltip.error.crash");
			list.add(crash.method_27692(class_124.field_1061));
			return list;
		}
	}

	@Override
	public class_327 getFontRenderer(class_310 minecraft, class_1799 ingredient) {
		IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
		return renderHelper.getFontRenderer(minecraft, ingredient);
	}

	@Override
	public int getWidth() {
		return 16;
	}

	@Override
	public int getHeight() {
		return 16;
	}
}
