package mezz.jei.library.plugins.vanilla.compostable;

import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import mezz.jei.api.recipe.vanilla.IJeiCompostingRecipe;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_3962;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;

public class CompostingRecipeMaker {
	public static List<IJeiCompostingRecipe> getRecipes(IIngredientManager ingredientManager) {
		Object2FloatMap<class_1935> compostables = class_3962.field_17566;
		Collection<class_1799> allIngredients = ingredientManager.getAllItemStacks();

		return allIngredients.stream()
			.<IJeiCompostingRecipe>mapMulti((itemStack, consumer) -> {
				class_1792 item = itemStack.method_7909();
				float compostValue = compostables.getOrDefault(item, 0);
				if (compostValue > 0) {
					CompostingRecipe recipe = new CompostingRecipe(itemStack, compostValue);
					consumer.accept(recipe);
				}
			})
			.limit(compostables.size())
			.sorted(Comparator.comparingDouble(IJeiCompostingRecipe::getChance))
			.toList();
	}
}
