package mezz.jei.library.plugins.vanilla.brewing;

import mezz.jei.api.recipe.vanilla.IJeiBrewingRecipe;
import mezz.jei.common.platform.IPlatformRegistry;
import mezz.jei.common.platform.Services;
import net.minecraft.class_1799;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_2960;
import net.minecraft.class_7924;
import java.util.List;
import java.util.Objects;

public class JeiBrewingRecipe implements IJeiBrewingRecipe {
	private final List<class_1799> ingredients;
	private final List<class_1799> potionInputs;
	private final class_1799 potionOutput;
	private final BrewingRecipeUtil brewingRecipeUtil;
	private final int hashCode;

	public JeiBrewingRecipe(List<class_1799> ingredients, List<class_1799> potionInputs, class_1799 potionOutput, BrewingRecipeUtil brewingRecipeUtil) {
		this.ingredients = List.copyOf(ingredients);
		this.potionInputs = List.copyOf(potionInputs);
		this.potionOutput = potionOutput;
		this.brewingRecipeUtil = brewingRecipeUtil;

		brewingRecipeUtil.addRecipe(potionInputs, potionOutput);

		this.hashCode = Objects.hash(
			ingredients.stream().map(class_1799::method_7909).toList(),
			potionInputs.stream().map(class_1799::method_7909).toList(),
			potionOutput.method_7909()
		);
	}

	@Override
	public List<class_1799> getPotionInputs() {
		return potionInputs;
	}

	@Override
	public List<class_1799> getIngredients() {
		return ingredients;
	}

	@Override
	public class_1799 getPotionOutput() {
		return potionOutput;
	}

	@Override
	public boolean equals(Object obj) {
		if (!(obj instanceof JeiBrewingRecipe other)) {
			return false;
		}

		for (int i = 0; i < potionInputs.size(); i++) {
			class_1799 potionInput = potionInputs.get(i);
			class_1799 otherPotionInput = other.potionInputs.get(i);
			if (!arePotionsEqual(potionInput, otherPotionInput)) {
				return false;
			}
		}

		if (!arePotionsEqual(other.potionOutput, potionOutput)) {
			return false;
		}

		if (ingredients.size() != other.ingredients.size()) {
			return false;
		}

		for (int i = 0; i < ingredients.size(); i++) {
			if (!class_1799.method_7973(ingredients.get(i), other.ingredients.get(i))) {
				return false;
			}
		}

		return true;
	}

	private static boolean arePotionsEqual(class_1799 potion1, class_1799 potion2) {
		if (potion1.method_7909() != potion2.method_7909()) {
			return false;
		}
		class_1842 type1 = class_1844.method_8063(potion1);
		class_1842 type2 = class_1844.method_8063(potion2);
		IPlatformRegistry<class_1842> potionRegistry = Services.PLATFORM.getRegistry(class_7924.field_41215);
		class_2960 key1 = potionRegistry.getRegistryName(type1).orElse(null);
		class_2960 key2 = potionRegistry.getRegistryName(type2).orElse(null);
		return Objects.equals(key1, key2);
	}

	@Override
	public int getBrewingSteps() {
		return brewingRecipeUtil.getBrewingSteps(potionOutput);
	}

	@Override
	public int hashCode() {
		return hashCode;
	}

	@Override
	public String toString() {
		class_1842 inputType = class_1844.method_8063(potionInputs.get(0));
		class_1842 outputType = class_1844.method_8063(potionOutput);
		return ingredients + " + [" + potionInputs.get(0).method_7909() + " " + inputType.method_8051("") + "] = [" + potionOutput + " " + outputType.method_8051("") + "]";
	}
}
