package mezz.jei.library.config.serializers;

import mezz.jei.api.runtime.config.IJeiConfigListValueSerializer;
import mezz.jei.api.runtime.config.IJeiConfigValueSerializer;
import mezz.jei.common.config.file.serializers.DeserializeResult;
import net.minecraft.class_124;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ChatFormattingSerializer implements IJeiConfigListValueSerializer<class_124> {
    public static final ChatFormattingSerializer INSTANCE = new ChatFormattingSerializer();

    private static final ChatFormattingValueSerializer VALUE_SERIALIZER = new ChatFormattingValueSerializer();
    private static final EnumSet<class_124> INVALID_VALUES = EnumSet.of(class_124.field_1070);
    private static final EnumSet<class_124> VALID_VALUES = EnumSet.complementOf(INVALID_VALUES);

    private ChatFormattingSerializer() {}

    @Override
    public String serialize(List<class_124> value) {
        return value.stream()
            .map(VALUE_SERIALIZER::serialize)
            .collect(Collectors.joining(" "));
    }

    @Override
    public DeserializeResult<List<class_124>> deserialize(String string) {
        string = string.trim();
        if (string.startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        if (string.isEmpty()) {
            return new DeserializeResult<>(List.of());
        }
        List<String> errors = new ArrayList<>();
        String[] strings = string.split(" ");
        List<class_124> result = Arrays.stream(strings)
            .<class_124>mapMulti((s, c) -> {
                IDeserializeResult<class_124> deserializeResult = VALUE_SERIALIZER.deserialize(s);
                deserializeResult.getResult().ifPresent(c);
                errors.addAll(deserializeResult.getErrors());
            })
            .toList();
        return new DeserializeResult<>(result, errors);
    }

    @Override
    public String getValidValuesDescription() {
        List<class_124> validColors = new ArrayList<>();
        List<class_124> validFormats = new ArrayList<>();

        for (class_124 chatFormatting : VALID_VALUES) {
            if (chatFormatting.method_543()) {
                validColors.add(chatFormatting);
            } else if (chatFormatting.method_542()) {
                validFormats.add(chatFormatting);
            }
        }

        return """
            A chat formatting string.
            Use these formatting colors:
            %s
            With these formatting options:
            %s""".formatted(serialize(validColors), serialize(validFormats));
    }

    @Override
    public boolean isValid(List<class_124> value) {
        return value.stream()
            .allMatch(VALUE_SERIALIZER::isValid);
    }

    @Override
    public IJeiConfigValueSerializer<class_124> getListValueSerializer() {
        return VALUE_SERIALIZER;
    }

    @Override
    public Optional<Collection<List<class_124>>> getAllValidValues() {
        return Optional.empty();
    }

    private static class ChatFormattingValueSerializer implements IJeiConfigValueSerializer<class_124> {
        @Override
        public String serialize(class_124 value) {
            return value.method_537();
        }

        @Override
        public IDeserializeResult<class_124> deserialize(String string) {
            class_124 chatFormatting = class_124.method_533(string);
            if (chatFormatting == null) {
                return new DeserializeResult<>(null, "No Chat Formatting found for name: '%s'".formatted(string));
            }
            if (INVALID_VALUES.contains(chatFormatting)) {
                return new DeserializeResult<>(null, "Chat Formatting '%s' is not valid".formatted(string));
            }
            return new DeserializeResult<>(chatFormatting);
        }

        @Override
        public boolean isValid(class_124 value) {
            return VALID_VALUES.contains(value);
        }

        @Override
        public Optional<Collection<class_124>> getAllValidValues() {
            return Optional.of(VALID_VALUES);
        }

        @Override
        public String getValidValuesDescription() {
            String validValuesString = VALID_VALUES.stream()
                .map(this::serialize)
                .collect(Collectors.joining(", "));

            return """
            A chat formatting string.
            Use any of these formatting values:
            %s""".formatted(validValuesString);
        }
    }
}
