package mezz.jei.gui.recipes;

import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferManager;
import mezz.jei.common.gui.TooltipRenderer;
import mezz.jei.gui.elements.GuiIconButtonSmall;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_768;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.transfer.RecipeTransferErrorInternal;
import mezz.jei.common.transfer.RecipeTransferUtil;
import org.jetbrains.annotations.Nullable;

import java.util.List;

public class RecipeTransferButton extends GuiIconButtonSmall {
	private final IRecipeLayoutDrawable<?> recipeLayout;
	private final Runnable onClose;
	@Nullable
	private IRecipeTransferError recipeTransferError;
	@Nullable
	private IOnClickHandler onClickHandler;

	public RecipeTransferButton(IDrawable icon, IRecipeLayoutDrawable<?> recipeLayout, Textures textures, Runnable onClose) {
		super(0, 0, 0, 0, icon, b -> {}, textures);
		this.recipeLayout = recipeLayout;
		this.onClose = onClose;
	}

	public void update(class_768 area, IRecipeTransferManager recipeTransferManager, @Nullable class_1703 container, class_1657 player) {
		this.method_46421(area.method_3321());
		this.method_46419(area.method_3322());
		this.field_22758 = area.method_3319();
		this.field_22759 = area.method_3320();

		if (container != null) {
			this.recipeTransferError = RecipeTransferUtil.getTransferRecipeError(recipeTransferManager, container, recipeLayout, player)
				.orElse(null);
		} else {
			this.recipeTransferError = RecipeTransferErrorInternal.INSTANCE;
		}

		if (recipeTransferError == null ||
			recipeTransferError.getType().allowsTransfer) {
			this.field_22763 = true;
			this.field_22764 = true;
		} else {
			this.field_22763 = false;
			IRecipeTransferError.Type type = this.recipeTransferError.getType();
			this.field_22764 = (type == IRecipeTransferError.Type.USER_FACING);
		}

		this.onClickHandler = (mouseX, mouseY) -> {
			boolean maxTransfer = class_437.method_25442();
			if (container != null && RecipeTransferUtil.transferRecipe(recipeTransferManager, container, recipeLayout, player, maxTransfer)) {
				onClose.run();
			}
		};
	}

	public void drawToolTip(class_4587 poseStack, int mouseX, int mouseY) {
		if (method_25405(mouseX, mouseY)) {
			if (recipeTransferError == null) {
				class_2561 tooltipTransfer = class_2561.method_43471("jei.tooltip.transfer");
				TooltipRenderer.drawHoveringText(poseStack, List.of(tooltipTransfer), mouseX, mouseY);
			} else {
				IRecipeSlotsView recipeSlotsView = recipeLayout.getRecipeSlotsView();
				class_768 recipeRect = recipeLayout.getRect();
				recipeTransferError.showError(poseStack, mouseX, mouseY, recipeSlotsView, recipeRect.method_3321(), recipeRect.method_3322());
			}
		}
	}

	@Override
	public boolean method_25405(double mouseX, double mouseY) {
		return this.field_22764 &&
			mouseX >= this.method_46426() &&
			mouseY >= this.method_46427() &&
			mouseX < this.method_46426() + this.method_25368() &&
			mouseY < this.method_46427() + this.method_25364();
	}

	@Override
	public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
		super.method_25394(poseStack, mouseX, mouseY, partialTicks);
		if (this.field_22764 && this.recipeTransferError != null && this.recipeTransferError.getType() == IRecipeTransferError.Type.COSMETIC) {
			method_25294(poseStack, this.method_46426(), this.method_46427(), this.method_46426() + this.method_25368(), this.method_46427() + this.method_25364(), this.recipeTransferError.getButtonHighlightColor());
		}
	}

	@Override
	public void method_25357(double mouseX, double mouseY) {
		if (!method_25405(mouseX, mouseY)) {
			return;
		}
		if (onClickHandler != null) {
			onClickHandler.onClick(mouseX, mouseY);
		}
	}
}
