package mezz.jei.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_5225;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public final class StringUtil {
	private StringUtil() {

	}

	public static class_2561 stripStyling(class_2561 textComponent) {
		class_5250 text = textComponent.method_27662();
		for (class_2561 sibling : textComponent.method_10855()) {
			text.method_10852(stripStyling(sibling));
		}
		return text;
	}

	public static class_2561 truncateStringToWidth(class_2561 text, int width, class_327 fontRenderer) {
		int ellipsisWidth = fontRenderer.method_1727("...");
		class_5348 truncatedText = fontRenderer.method_1714(text, width - ellipsisWidth);
		String truncatedTextString = truncatedText.getString();
		return class_2561.method_43470(truncatedTextString + "...");
	}

	public static List<class_5348> splitLines(List<class_5348> lines, int width) {
		if (width <= 0) {
			return List.copyOf(lines);
		}

		class_310 minecraft = class_310.method_1551();
		class_327 font = minecraft.field_1772;
		class_5225 splitter = font.method_27527();
		return lines.stream()
			.flatMap(text -> splitter.method_27495(text, width, class_2583.field_24360).stream())
			.toList();
	}

	public static List<class_5348> expandNewlines(class_2561... descriptionComponents) {
		List<class_5348> descriptionLinesExpanded = new ArrayList<>();
		for (class_2561 descriptionLine : descriptionComponents) {
			ExpandNewLineTextAcceptor newLineTextAcceptor = new ExpandNewLineTextAcceptor();
			descriptionLine.method_27658(newLineTextAcceptor, class_2583.field_24360);
			newLineTextAcceptor.addLinesTo(descriptionLinesExpanded);
		}
		return descriptionLinesExpanded;
	}

	public static String intsToString(Collection<Integer> indexes) {
		return indexes.stream()
			.sorted()
			.map(i -> Integer.toString(i))
			.collect(Collectors.joining(", "));
	}
}
