package mezz.jei.common.gui.elements;

import com.mojang.blaze3d.systems.RenderSystem;
import mezz.jei.common.Constants;
import mezz.jei.common.gui.textures.JeiSpriteUploader;
import net.minecraft.class_1058;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import mezz.jei.api.gui.drawable.IDrawableStatic;

import org.joml.Matrix4f;

public class DrawableSprite implements IDrawableStatic {
	private final JeiSpriteUploader spriteUploader;
	private final class_2960 location;
	private final int width;
	private final int height;
	private int trimLeft;
	private int trimRight;
	private int trimTop;
	private int trimBottom;

	public DrawableSprite(JeiSpriteUploader spriteUploader, class_2960 location, int width, int height) {
		this.spriteUploader = spriteUploader;
		this.location = location;
		this.width = width;
		this.height = height;
	}

	public DrawableSprite trim(int left, int right, int top, int bottom) {
		this.trimLeft = left;
		this.trimRight = right;
		this.trimTop = top;
		this.trimBottom = bottom;
		return this;
	}

	@Override
	public int getWidth() {
		return width;
	}

	@Override
	public int getHeight() {
		return height;
	}

	@Override
	public void draw(class_4587 poseStack, int xOffset, int yOffset) {
		draw(poseStack, xOffset, yOffset, 0, 0, 0, 0);
	}

	@Override
	public void draw(class_4587 poseStack, int xOffset, int yOffset, int maskTop, int maskBottom, int maskLeft, int maskRight) {
		class_1058 sprite = spriteUploader.method_18667(location);
		int textureWidth = this.width;
		int textureHeight = this.height;

		RenderSystem.setShader(class_757::method_34542);
		RenderSystem.setShaderTexture(0, Constants.LOCATION_JEI_GUI_TEXTURE_ATLAS);

		maskTop += trimTop;
		maskBottom += trimBottom;
		maskLeft += trimLeft;
		maskRight += trimRight;

		int x = xOffset + maskLeft;
		int y = yOffset + maskTop;
		int width = textureWidth - maskRight - maskLeft;
		int height = textureHeight - maskBottom - maskTop;
		float uSize = sprite.method_4577() - sprite.method_4594();
		float vSize = sprite.method_4575() - sprite.method_4593();

		float minU = sprite.method_4594() + uSize * (maskLeft / (float) textureWidth);
		float minV = sprite.method_4593() + vSize * (maskTop / (float) textureHeight);
		float maxU = sprite.method_4577() - uSize * (maskRight / (float) textureWidth);
		float maxV = sprite.method_4575() - vSize * (maskBottom / (float) textureHeight);

		class_289 tessellator = class_289.method_1348();
		class_287 bufferBuilder = tessellator.method_1349();
		bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
		Matrix4f matrix = poseStack.method_23760().method_23761();
		bufferBuilder.method_22918(matrix, x, y + height, 0)
			.method_22913(minU, maxV)
			.method_1344();
		bufferBuilder.method_22918(matrix, x + width, y + height, 0)
			.method_22913(maxU, maxV)
			.method_1344();
		bufferBuilder.method_22918(matrix, x + width, y, 0)
			.method_22913(maxU, minV)
			.method_1344();
		bufferBuilder.method_22918(matrix, x, y, 0)
			.method_22913(minU, minV)
			.method_1344();
		tessellator.method_1350();
	}
}
