package mezz.jei.library.plugins.jei.ingredients;

import com.mojang.blaze3d.systems.RenderSystem;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.class_124;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import java.util.ArrayList;
import java.util.List;

public class DebugIngredientRenderer implements IIngredientRenderer<DebugIngredient> {
	private final IIngredientHelper<DebugIngredient> ingredientHelper;

	public DebugIngredientRenderer(IIngredientHelper<DebugIngredient> ingredientHelper) {
		this.ingredientHelper = ingredientHelper;
	}

	@Override
	public void render(class_4587 poseStack, DebugIngredient ingredient) {
		class_310 minecraft = class_310.method_1551();
		class_327 font = getFontRenderer(minecraft, ingredient);
		font.method_1729(poseStack, "JEI", 0, 0, 0xFFFF0000);
		font.method_1729(poseStack, "#" + ingredient.getNumber(), 0, 8, 0xFFFF0000);
		RenderSystem.setShaderColor(1, 1, 1, 1);
	}

	@Override
	public List<class_2561> getTooltip(DebugIngredient ingredient, class_1836 tooltipFlag) {
		List<class_2561> tooltip = new ArrayList<>();
		String displayName = ingredientHelper.getDisplayName(ingredient);
		tooltip.add(class_2561.method_43470(displayName));
		class_5250 debugIngredient = class_2561.method_43470("debug ingredient");
		tooltip.add(debugIngredient.method_27692(class_124.field_1080));
		return tooltip;
	}
}
