package mezz.jei.library.plugins.debug;

import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.ModIds;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IClickableIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.common.config.DebugConfig;
import mezz.jei.common.platform.IPlatformRegistry;
import mezz.jei.common.platform.IPlatformScreenHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.common.util.MathUtil;
import mezz.jei.library.plugins.jei.ingredients.DebugIngredient;
import mezz.jei.library.plugins.jei.ingredients.DebugIngredientHelper;
import mezz.jei.library.plugins.jei.ingredients.DebugIngredientListFactory;
import mezz.jei.library.plugins.jei.ingredients.DebugIngredientRenderer;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_472;
import net.minecraft.class_768;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JeiPlugin
public class JeiDebugPlugin implements IModPlugin {
	private @Nullable DebugRecipeCategory<?> debugRecipeCategory;

	@Override
	public class_2960 getPluginUid() {
		return new class_2960(ModIds.JEI_ID, "debug");
	}

	@Override
	public void registerIngredients(IModIngredientRegistration registration) {
		if (DebugConfig.isDebugModeEnabled()) {
			DebugIngredientHelper ingredientHelper = new DebugIngredientHelper();
			DebugIngredientRenderer ingredientRenderer = new DebugIngredientRenderer(ingredientHelper);
			registration.register(DebugIngredient.TYPE, Collections.emptyList(), ingredientHelper, ingredientRenderer);
		}
	}

	@Override
	public void registerCategories(IRecipeCategoryRegistration registration) {
		if (DebugConfig.isDebugModeEnabled()) {
			IJeiHelpers jeiHelpers = registration.getJeiHelpers();
			IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
			IPlatformFluidHelper<?> platformFluidHelper = jeiHelpers.getPlatformFluidHelper();
			IIngredientManager ingredientManager = jeiHelpers.getIngredientManager();
			this.debugRecipeCategory = new DebugRecipeCategory<>(guiHelper, platformFluidHelper, ingredientManager);
			registration.addRecipeCategories(
				debugRecipeCategory,
				new DebugFocusRecipeCategory<>(guiHelper, platformFluidHelper)
			);
		}
	}

	@Override
	public void registerRecipes(IRecipeRegistration registration) {
		if (DebugConfig.isDebugModeEnabled()) {
			registration.addItemStackInfo(List.of(
				new class_1799(class_2246.field_10149),
				new class_1799(class_2246.field_10521),
				new class_1799(class_2246.field_10352),
				new class_1799(class_2246.field_10627),
				new class_1799(class_2246.field_10232),
				new class_1799(class_2246.field_10403)
				),
				class_2561.method_43471("description.jei.wooden.door.1"), // actually 2 lines
				class_2561.method_43471("description.jei.wooden.door.2"),
				class_2561.method_43471("description.jei.wooden.door.3")
			);

			IJeiHelpers jeiHelpers = registration.getJeiHelpers();
			IPlatformFluidHelper<?> platformFluidHelper = jeiHelpers.getPlatformFluidHelper();
			registerFluidRecipes(registration, platformFluidHelper);
			registration.addIngredientInfo(new DebugIngredient(1), DebugIngredient.TYPE, class_2561.method_43470("debug"));
			registration.addIngredientInfo(new DebugIngredient(2), DebugIngredient.TYPE,
				class_2561.method_43470("debug colored").method_27692(class_124.field_1075),
				class_2561.method_43470("debug\\nSplit and colored").method_27692(class_124.field_1076),
				class_2561.method_43469("description.jei.debug.formatting.1", "various"),
				class_2561.method_43469("description.jei.debug.formatting.1", "various\\nsplit"),
				class_2561.method_43469("description.jei.debug.formatting.1", class_2561.method_43470("various colored").method_27692(class_124.field_1061)),
				class_2561.method_43469("description.jei.debug.formatting.1",
					class_2561.method_43470("various\\nsplit colored").method_27692(class_124.field_1062)
				),
				class_2561.method_43469("description.jei.debug.formatting.1", "\\nSplitting at the start"),
				class_2561.method_43469("description.jei.debug.formatting.1", "various all colored").method_27692(class_124.field_1061),
				class_2561.method_43469("description.jei.debug.formatting.1",
					class_2561.method_43469("description.jei.debug.formatting.3", "various").method_27692(class_124.field_1062)
				),
				class_2561.method_43469("description.jei.debug.formatting.2",
					class_2561.method_43470("multiple").method_27692(class_124.field_1065).method_27692(class_124.field_1056),
					class_2561.method_43470("various").method_27692(class_124.field_1061)
				).method_27692(class_124.field_1078),
				class_2561.method_43469("description.jei.debug.formatting.1",
					class_2561.method_43469("description.jei.debug.formatting.3",
						class_2561.method_43469("description.jei.debug.formatting.2",
							class_2561.method_43470("multiple").method_27692(class_124.field_1065).method_27692(class_124.field_1056),
							class_2561.method_43470("various").method_27692(class_124.field_1061)
						).method_27692(class_124.field_1062)
					)
				)
			);

			registration.addRecipes(DebugRecipeCategory.TYPE, List.of(
				new DebugRecipe(),
				new DebugRecipe()
			));

			registration.addRecipes(DebugFocusRecipeCategory.TYPE, List.of(
				new DebugRecipe()
			));
		}
	}

	private <T> void registerFluidRecipes(IRecipeRegistration registration, IPlatformFluidHelper<T> platformFluidHelper) {
		long bucketVolume = platformFluidHelper.bucketVolume();
		T fluidIngredient = platformFluidHelper.create(class_3612.field_15910, bucketVolume, null);
		registration.addIngredientInfo(fluidIngredient, platformFluidHelper.getFluidIngredientType(), class_2561.method_43470("water"));
	}

	@Override
	public void registerGuiHandlers(IGuiHandlerRegistration registration) {
		if (DebugConfig.isDebugModeEnabled()) {
			IJeiHelpers jeiHelpers = registration.getJeiHelpers();
			IIngredientManager ingredientManager = jeiHelpers.getIngredientManager();

			registration.addGuiContainerHandler(class_472.class, new IGuiContainerHandler<>() {
				@Override
				public List<class_768> getGuiExtraAreas(class_472 containerScreen) {
					int widthMovement = (int) ((System.currentTimeMillis() / 100) % 100);
					int size = 25 + widthMovement;
					IPlatformScreenHelper screenHelper = Services.PLATFORM.getScreenHelper();
					int guiLeft = screenHelper.getGuiLeft(containerScreen);
					int xSize = screenHelper.getXSize(containerScreen);
					int guiTop = screenHelper.getGuiTop(containerScreen);
					return List.of(
						new class_768(guiLeft + xSize, guiTop + 40, size, size)
					);
				}

				@Override
				public Optional<IClickableIngredient<?>> getClickableIngredientUnderMouse(class_472 containerScreen, double mouseX, double mouseY) {
					class_768 area = new class_768(0, 0, 10, 10);
					if (MathUtil.contains(area, mouseX, mouseY)) {
						return ingredientManager.createTypedIngredient(VanillaTypes.ITEM_STACK, new class_1799(class_1802.field_8102))
							.map(item -> new DebugClickableIngredient<>(item, area));
					}
					return Optional.empty();
				}
			});

			registration.addGhostIngredientHandler(class_472.class, new DebugGhostIngredientHandler<>(ingredientManager));
		}
	}

	private static class DebugClickableIngredient<T> implements IClickableIngredient<T> {
		private final ITypedIngredient<T> typedIngredient;
		private final class_768 area;

		public DebugClickableIngredient(ITypedIngredient<T> typedIngredient, class_768 area) {
			this.typedIngredient = typedIngredient;
			this.area = area;
		}

		@Override
		public ITypedIngredient<T> getTypedIngredient() {
			return typedIngredient;
		}

		@Override
		public class_768 getArea() {
			return area;
		}
	}

	@Override
	public <T> void registerFluidSubtypes(ISubtypeRegistration registration, IPlatformFluidHelper<T> platformFluidHelper) {
		class_3611 water = class_3612.field_15910;
		IIngredientTypeWithSubtypes<class_3611, T> ingredientType = platformFluidHelper.getFluidIngredientType();
		FluidSubtypeHandlerTest<T> subtype = new FluidSubtypeHandlerTest<>(ingredientType);
		registration.registerSubtypeInterpreter(ingredientType, water, subtype);
	}

	@Override
	public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
		if (DebugConfig.isDebugModeEnabled()) {
			IPlatformFluidHelper<?> fluidHelper = Services.PLATFORM.getFluidHelper();
			registerRecipeCatalysts(registration, fluidHelper);
		}
	}

	private <T> void registerRecipeCatalysts(IRecipeCatalystRegistration registration, IPlatformFluidHelper<T> fluidHelper) {
		long bucketVolume = fluidHelper.bucketVolume();

		registration.addRecipeCatalyst(DebugIngredient.TYPE, new DebugIngredient(7), DebugRecipeCategory.TYPE);
		registration.addRecipeCatalyst(fluidHelper.getFluidIngredientType(), fluidHelper.create(class_3612.field_15910, bucketVolume, null), DebugRecipeCategory.TYPE);
		registration.addRecipeCatalyst(new class_1799(class_1802.field_8600), DebugRecipeCategory.TYPE);
		IPlatformRegistry<class_1792> registry = Services.PLATFORM.getRegistry(class_7924.field_41197);
		registry.getValues()
			.limit(300)
			.forEach(item -> {
				class_1799 catalystIngredient = new class_1799(item);
				if (!catalystIngredient.method_7960()) {
					registration.addRecipeCatalyst(catalystIngredient, DebugRecipeCategory.TYPE);
				}
			});
	}

	@Override
	public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
		if (DebugConfig.isDebugModeEnabled()) {
			ErrorUtil.assertMainThread();
			if (debugRecipeCategory != null) {
				debugRecipeCategory.setRuntime(jeiRuntime);
			}
			IIngredientManager ingredientManager = jeiRuntime.getIngredientManager();
			ingredientManager.addIngredientsAtRuntime(DebugIngredient.TYPE, DebugIngredientListFactory.create());
		}
	}
}
