package mezz.jei.library.color;

import mezz.jei.api.helpers.IColorHelper;
import mezz.jei.library.config.ColorNameConfig;
import net.minecraft.class_1058;
import net.minecraft.class_1799;
import java.util.List;

public class ColorHelper implements IColorHelper {
    private final ColorGetter colorGetter;
    private final ColorNameConfig colorNameConfig;

    public ColorHelper(ColorNameConfig colorNameConfig) {
        this.colorGetter = new ColorGetter();
        this.colorNameConfig = colorNameConfig;
    }

    @Override
    public List<Integer> getColors(class_1058 textureAtlasSprite, int renderColor, int colorCount) {
        return colorGetter.getColors(textureAtlasSprite, renderColor, colorCount);
    }

    @Override
    public List<Integer> getColors(class_1799 itemStack, int colorCount) {
        return colorGetter.getColors(itemStack, colorCount);
    }

    @Override
    public String getClosestColorName(int color) {
        return colorNameConfig.getClosestColorName(color);
    }
}
