package mezz.jei.gui.ghost;

import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.MathUtil;
import net.minecraft.class_241;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import java.util.Optional;

/**
 * Renders an item returning to the ingredient list after a failed ghost drag.
 */
public class GhostIngredientReturning<T> {
	private static final long DURATION_PER_SCREEN_WIDTH = 500; // milliseconds to move across a full screen
	private final IIngredientRenderer<T> ingredientRenderer;
	private final ITypedIngredient<T> ingredient;
	private final class_241 start;
	private final class_241 end;
	private final long startTime;
	private final long duration;

	public static <T> Optional<GhostIngredientReturning<T>> create(GhostIngredientDrag<T> ghostIngredientDrag, double mouseX, double mouseY) {
		ImmutableRect2i origin = ghostIngredientDrag.getOrigin();
		if (origin.isEmpty()) {
			return Optional.empty();
		}

		IIngredientRenderer<T> ingredientRenderer = ghostIngredientDrag.getIngredientRenderer();
		ITypedIngredient<T> ingredient = ghostIngredientDrag.getIngredient();
		class_241 end = new class_241(origin.getX(), origin.getY());
		class_241 start = new class_241((float) mouseX - 8, (float) mouseY - 8);
		GhostIngredientReturning<T> returning = new GhostIngredientReturning<>(ingredientRenderer, ingredient, start, end);
		return Optional.of(returning);
	}

	private GhostIngredientReturning(IIngredientRenderer<T> ingredientRenderer, ITypedIngredient<T> ingredient, class_241 start, class_241 end) {
		this.ingredientRenderer = ingredientRenderer;
		this.ingredient = ingredient;
		this.start = start;
		this.end = end;
		this.startTime = System.currentTimeMillis();
		class_437 currentScreen = class_310.method_1551().field_1755;
		if (currentScreen != null) {
			int width = currentScreen.field_22789;
			float durationPerPixel = DURATION_PER_SCREEN_WIDTH / (float) width;
			float distance = (float) MathUtil.distance(start, end);
			this.duration = Math.round(durationPerPixel * distance);
		} else {
			this.duration = Math.round(0.5f * DURATION_PER_SCREEN_WIDTH);
		}
	}

	public void drawItem(class_4587 poseStack) {
		long time = System.currentTimeMillis();
		long elapsed = time - startTime;
		double percent = Math.min(elapsed / (double) this.duration, 1);
		double dx = end.field_1343 - start.field_1343;
		double dy = end.field_1342 - start.field_1342;
		double x = start.field_1343 + Math.round(dx * percent);
		double y = start.field_1342 + Math.round(dy * percent);
		poseStack.method_22903();
		{
			poseStack.method_22904(x, y, 0);
			ingredientRenderer.render(poseStack, ingredient.getIngredient());
		}
		poseStack.method_22909();
	}

	public boolean isComplete() {
		long time = System.currentTimeMillis();
		return startTime + this.duration < time;
	}

}
