package mezz.jei.gui.elements;

import com.mojang.blaze3d.systems.RenderSystem;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.common.gui.elements.DrawableNineSliceTexture;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.util.ImmutableRect2i;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_5244;

/**
 * A small gui button that has an {@link IDrawable} instead of a string label.
 */
public class GuiIconButtonSmall extends class_4185 {
	private final IDrawable icon;
	private final Textures textures;

	public GuiIconButtonSmall(int x, int y, int widthIn, int heightIn, IDrawable icon, class_4185.class_4241 pressable, Textures textures) {
		super(x, y, widthIn, heightIn, class_5244.field_39003, pressable, class_4185.field_40754);
		this.icon = icon;
		this.textures = textures;
	}

	public ImmutableRect2i getArea() {
		return new ImmutableRect2i(method_46426(), method_46427(), method_25368(), method_25364());
	}

	@Override
	public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
		if (this.field_22764) {
			RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, 1.0F);
			boolean hovered = method_25405(mouseX, mouseY);
			DrawableNineSliceTexture texture = textures.getButtonForState(this.field_22763, hovered);
			texture.draw(poseStack, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());

			int color = 0xFFE0E0E0;
			if (!this.field_22763) {
				color = 0xFFA0A0A0;
			} else if (hovered) {
				color = 0xFFFFFFFF;
			}

			float red = (color >> 16 & 255) / 255.0F;
			float blue = (color >> 8 & 255) / 255.0F;
			float green = (color & 255) / 255.0F;
			float alpha = (color >> 24 & 255) / 255.0F;
			RenderSystem.setShaderColor(red, blue, green, alpha);

			double xOffset = method_46426() + (method_25368() - this.icon.getWidth()) / 2.0;
			double yOffset = method_46427() + (method_25364() - this.icon.getHeight()) / 2.0;
			poseStack.method_22903();
			{
				poseStack.method_22904(xOffset, yOffset, 0);
				this.icon.draw(poseStack);
			}
			poseStack.method_22909();
		}
	}
}
