package mezz.jei.api.gui.builder;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2487;
import net.minecraft.class_3611;
import org.jetbrains.annotations.Nullable;

import java.util.List;

/**
 * A chainable interface that accepts typed ingredients.
 * Has convenience functions to make adding ingredients easier.
 *
 * @see IRecipeLayoutBuilder
 * @see IRecipeSlotBuilder
 *
 * @since 9.3.0
 */
public interface IIngredientAcceptor<THIS extends IIngredientAcceptor<THIS>> {
	/**
	 * Add an ordered list of ingredients.
	 *
	 * @since 9.3.0
	 */
	<I> THIS addIngredients(IIngredientType<I> ingredientType, List<@Nullable I> ingredients);

	/**
	 * Add one ingredient.
	 *
	 * @since 9.3.0
	 */
	<I> THIS addIngredient(IIngredientType<I> ingredientType, I ingredient);

	/**
	 * Add an ordered list of ingredients.
	 * The type of ingredients can be mixed, as long as they are all valid ingredient types.
	 * Prefer using {@link #addIngredients(IIngredientType, List)} for type safety.
	 *
	 * @since 9.3.0
	 */
	THIS addIngredientsUnsafe(List<?> ingredients);

	/**
	 * Convenience function to add an ordered list of {@link class_1799} from an {@link class_1856}.
	 *
	 * @since 9.3.0
	 */
	default THIS addIngredients(class_1856 ingredient) {
		return addIngredients(VanillaTypes.ITEM_STACK, List.of(ingredient.method_8105()));
	}

	/**
	 * Convenience function to add an order list of {@link class_1799}.
	 *
	 * @since 9.3.0
	 */
	default THIS addItemStacks(List<class_1799> itemStacks) {
		return addIngredients(VanillaTypes.ITEM_STACK, itemStacks);
	}

	/**
	 * Convenience function to add one {@link class_1799}.
	 *
	 * @since 9.3.0
	 */
	default THIS addItemStack(class_1799 itemStack) {
		return addIngredient(VanillaTypes.ITEM_STACK, itemStack);
	}

	/**
	 * Convenience helper to add one Fluid ingredient.
	 *
	 * To add multiple Fluid ingredients, you can call this multiple times.
	 *
	 * @see #addFluidStack(class_3611, long, class_2487) to add a Fluid with a {@link class_2487}.
	 * @since 11.1.0
	 */
	THIS addFluidStack(class_3611 fluid, long amount);

	/**
	 * Convenience helper to add one Fluid ingredient with a {@link class_2487}.
	 *
	 * To add multiple Fluid ingredients, you can call this multiple times.
	 *
	 * @see #addFluidStack(class_3611, long) to add a Fluid without a {@link class_2487}.
	 * @since 11.1.0
	 */
	THIS addFluidStack(class_3611 fluid, long amount, class_2487 tag);
}
