/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.gui.elements;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.ingredients.IIngredientRenderer;

public class DrawableIngredient<V>
implements IDrawable {
    private final V ingredient;
    private final IIngredientRenderer<V> ingredientRenderer;

    public DrawableIngredient(V ingredient, IIngredientRenderer<V> ingredientRenderer) {
        this.ingredient = ingredient;
        this.ingredientRenderer = ingredientRenderer;
    }

    public int getWidth() {
        return this.ingredientRenderer.getWidth();
    }

    public int getHeight() {
        return this.ingredientRenderer.getHeight();
    }

    public void draw(PoseStack poseStack) {
        RenderSystem.enableDepthTest();
        this.ingredientRenderer.render(poseStack, this.ingredient);
        RenderSystem.disableDepthTest();
    }

    public void draw(PoseStack poseStack, int xOffset, int yOffset) {
        poseStack.pushPose();
        poseStack.translate((float)xOffset, (float)yOffset, 0.0f);
        this.draw(poseStack);
        poseStack.popPose();
    }
}

