/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.util;

import java.util.Collection;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.platform.IPlatformModHelper;
import mezz.jei.common.platform.IPlatformRegistry;
import mezz.jei.common.platform.Services;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public final class ErrorUtil {
    private ErrorUtil() {
    }

    public static <T> String getIngredientInfo(T ingredient, IIngredientType<T> ingredientType, IIngredientManager ingredientManager) {
        IIngredientHelper ingredientHelper = ingredientManager.getIngredientHelper(ingredientType);
        return ingredientHelper.getErrorInfo(ingredient);
    }

    public static String getItemStackInfo(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            return "null";
        }
        Item item = itemStack.getItem();
        IPlatformRegistry<Item> itemRegistry = Services.PLATFORM.getRegistry(Registries.ITEM);
        String itemName = itemRegistry.getRegistryName(item).map(ResourceLocation::toString).orElseGet(() -> {
            if (item instanceof BlockItem) {
                String blockName;
                Block block = ((BlockItem)item).getBlock();
                if (block == null) {
                    blockName = "null";
                } else {
                    IPlatformRegistry<Block> blockRegistry = Services.PLATFORM.getRegistry(Registries.BLOCK);
                    blockName = blockRegistry.getRegistryName(block).map(ResourceLocation::toString).orElseGet(() -> block.getClass().getName());
                }
                return "BlockItem(" + blockName + ")";
            }
            return item.getClass().getName();
        });
        CompoundTag nbt = itemStack.getTag();
        if (nbt != null) {
            return itemStack + " " + itemName + " nbt:" + nbt;
        }
        return itemStack + " " + itemName;
    }

    public static void checkNotEmpty(ItemStack itemStack) {
        if (itemStack == null) {
            throw new NullPointerException("ItemStack must not be null.");
        }
        if (itemStack.isEmpty()) {
            String info = ErrorUtil.getItemStackInfo(itemStack);
            throw new IllegalArgumentException("ItemStack value must not be empty. " + info);
        }
    }

    public static void checkNotEmpty(ItemStack itemStack, String name) {
        if (itemStack == null) {
            throw new NullPointerException(name + " must not be null.");
        }
        if (itemStack.isEmpty()) {
            String info = ErrorUtil.getItemStackInfo(itemStack);
            throw new IllegalArgumentException("ItemStack " + name + " must not be empty. " + info);
        }
    }

    public static <T> void checkNotEmpty(T[] values, String name) {
        if (values == null) {
            throw new NullPointerException(name + " must not be null.");
        }
        if (values.length == 0) {
            throw new IllegalArgumentException(name + " must not be empty.");
        }
        for (T value : values) {
            if (value != null) continue;
            throw new NullPointerException(name + " must not contain null values.");
        }
    }

    public static void checkNotEmpty(Collection<?> values, String name) {
        if (values == null) {
            throw new NullPointerException(name + " must not be null.");
        }
        if (values.isEmpty()) {
            throw new IllegalArgumentException(name + " must not be empty.");
        }
        if (!(values instanceof NonNullList)) {
            for (Object value : values) {
                if (value != null) continue;
                throw new NullPointerException(name + " must not contain null values.");
            }
        }
    }

    public static <T> void checkNotNull(@Nullable T object, String name) {
        if (object == null) {
            throw new NullPointerException(name + " must not be null.");
        }
    }

    public static void checkNotNull(Collection<?> values, String name) {
        if (values == null) {
            throw new NullPointerException(name + " must not be null.");
        }
        if (!(values instanceof NonNullList)) {
            for (Object value : values) {
                if (value != null) continue;
                throw new NullPointerException(name + " must not contain null values.");
            }
        }
    }

    public static void assertMainThread() {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft != null && !minecraft.isSameThread()) {
            Thread currentThread = Thread.currentThread();
            throw new IllegalStateException("A JEI API method is being called by another mod from the wrong thread:\n" + currentThread + "\nIt must be called on the main thread by using Minecraft.addScheduledTask.");
        }
    }

    public static <T> ReportedException createRenderIngredientException(Throwable throwable, T ingredient, IIngredientManager ingredientManager) {
        CrashReport crashreport = CrashReport.forThrowable((Throwable)throwable, (String)"Rendering ingredient");
        CrashReportCategory ingredientCategory = crashreport.addCategory("Ingredient being rendered");
        ingredientCategory.setDetail("String Name", ingredient::toString);
        ingredientCategory.setDetail("Class Name", () -> ingredient.getClass().toString());
        IPlatformModHelper modHelper = Services.PLATFORM.getModHelper();
        ingredientManager.getIngredientTypeChecked(ingredient).ifPresentOrElse(ingredientType -> {
            IIngredientHelper ingredientHelper = ingredientManager.getIngredientHelper(ingredientType);
            ingredientCategory.setDetail("Mod Name", () -> {
                String modId = ingredientHelper.getDisplayModId(ingredient);
                return modHelper.getModNameForModId(modId);
            });
            ingredientCategory.setDetail("Registry Name", () -> ingredientHelper.getResourceLocation(ingredient).toString());
            ingredientCategory.setDetail("Display Name", () -> ingredientHelper.getDisplayName(ingredient));
            CrashReportCategory jeiCategory = crashreport.addCategory("JEI render details");
            jeiCategory.setDetail("Unique Id (for Blacklist)", () -> ingredientHelper.getUniqueId(ingredient, UidContext.Ingredient));
            jeiCategory.setDetail("Ingredient Type", () -> ingredientType.getIngredientClass().toString());
            jeiCategory.setDetail("Error Info", () -> ingredientHelper.getErrorInfo(ingredient));
        }, () -> {
            CrashReportCategory jeiCategory = crashreport.addCategory("JEI render details");
            jeiCategory.setDetail("Ingredient Type", (Object)"Error, Unknown Ingredient Type");
        });
        throw new ReportedException(crashreport);
    }
}

