/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.config.file;

import java.util.List;
import mezz.jei.api.runtime.config.IJeiConfigValue;
import mezz.jei.api.runtime.config.IJeiConfigValueSerializer;
import mezz.jei.common.config.file.IConfigSchema;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ConfigValue<T>
implements IJeiConfigValue<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final String name;
    private final String description;
    private final T defaultValue;
    private final IJeiConfigValueSerializer<T> serializer;
    private volatile T currentValue;
    @Nullable
    private IConfigSchema schema;

    public ConfigValue(String name, T defaultValue, IJeiConfigValueSerializer<T> serializer, String description) {
        this.name = name;
        this.description = description;
        this.defaultValue = defaultValue;
        this.currentValue = defaultValue;
        this.serializer = serializer;
    }

    public void setSchema(IConfigSchema schema) {
        this.schema = schema;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public T getValue() {
        if (this.schema != null) {
            this.schema.loadIfNeeded();
        }
        return this.currentValue;
    }

    public IJeiConfigValueSerializer<T> getSerializer() {
        return this.serializer;
    }

    public List<String> setFromSerializedValue(String value) {
        IJeiConfigValueSerializer.IDeserializeResult deserializeResult = this.serializer.deserialize(value);
        deserializeResult.getResult().ifPresent(t -> {
            this.currentValue = t;
        });
        return deserializeResult.getErrors();
    }

    public boolean set(T value) {
        if (!this.serializer.isValid(value)) {
            LOGGER.error("Tried to set invalid value : {}\n{}", value, (Object)this.serializer.getValidValuesDescription());
            return false;
        }
        if (!this.currentValue.equals(value)) {
            this.currentValue = value;
            if (this.schema != null) {
                this.schema.markDirty();
            }
            return true;
        }
        return false;
    }
}

