/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay;

import java.util.List;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.common.Internal;
import mezz.jei.common.config.IWorldConfig;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.common.network.IConnectionToServer;
import mezz.jei.common.network.packets.PacketJei;
import mezz.jei.common.network.packets.PacketRequestCheatPermission;
import mezz.jei.common.platform.IPlatformConfigHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.gui.elements.GuiIconToggleButton;
import mezz.jei.gui.input.UserInput;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public class ConfigButton
extends GuiIconToggleButton {
    private final IInternalKeyMappings keyBindings;
    private final BooleanSupplier isListDisplayed;
    private final IWorldConfig worldConfig;

    public static ConfigButton create(BooleanSupplier isListDisplayed, IWorldConfig worldConfig, Textures textures, IInternalKeyMappings keyBindings) {
        return new ConfigButton((IDrawable)textures.getConfigButtonIcon(), (IDrawable)textures.getConfigButtonCheatIcon(), isListDisplayed, worldConfig, textures, keyBindings);
    }

    private ConfigButton(IDrawable disabledIcon, IDrawable enabledIcon, BooleanSupplier isListDisplayed, IWorldConfig worldConfig, Textures textures, IInternalKeyMappings keyBindings) {
        super(disabledIcon, enabledIcon, textures);
        this.isListDisplayed = isListDisplayed;
        this.worldConfig = worldConfig;
        this.keyBindings = keyBindings;
    }

    @Override
    protected void getTooltips(List<Component> tooltip) {
        tooltip.add((Component)Component.translatable((String)"jei.tooltip.config"));
        if (!this.worldConfig.isOverlayEnabled()) {
            MutableComponent disabled = Component.translatable((String)"jei.tooltip.ingredient.list.disabled");
            MutableComponent disabledFix = Component.translatable((String)"jei.tooltip.ingredient.list.disabled.how.to.fix", (Object[])new Object[]{this.keyBindings.getToggleOverlay().getTranslatedKeyMessage()});
            tooltip.add((Component)disabled.withStyle(ChatFormatting.GOLD));
            tooltip.add((Component)disabledFix.withStyle(ChatFormatting.GOLD));
        } else if (!this.isListDisplayed.getAsBoolean()) {
            MutableComponent notEnoughSpace = Component.translatable((String)"jei.tooltip.not.enough.space");
            tooltip.add((Component)notEnoughSpace.withStyle(ChatFormatting.GOLD));
        }
        if (this.worldConfig.isCheatItemsEnabled()) {
            MutableComponent enabled = Component.translatable((String)"jei.tooltip.cheat.mode.button.enabled").withStyle(ChatFormatting.RED);
            tooltip.add((Component)enabled);
            if (!this.keyBindings.getToggleCheatMode().isUnbound()) {
                component = Component.translatable((String)"jei.tooltip.cheat.mode.how.to.disable.hotkey", (Object[])new Object[]{this.keyBindings.getToggleCheatMode().getTranslatedKeyMessage()}).withStyle(ChatFormatting.RED);
                tooltip.add((Component)component);
            } else if (!this.keyBindings.getToggleCheatModeConfigButton().isUnbound()) {
                component = Component.translatable((String)"jei.tooltip.cheat.mode.how.to.disable.hover.config.button.hotkey", (Object[])new Object[]{this.keyBindings.getToggleCheatModeConfigButton().getTranslatedKeyMessage()}).withStyle(ChatFormatting.RED);
                tooltip.add((Component)component);
            }
        }
    }

    @Override
    protected boolean isIconToggledOn() {
        return this.worldConfig.isCheatItemsEnabled();
    }

    @Override
    protected boolean onMouseClicked(UserInput input) {
        if (this.worldConfig.isOverlayEnabled()) {
            if (!input.isSimulate()) {
                if (input.is(this.keyBindings.getToggleCheatModeConfigButton())) {
                    this.worldConfig.toggleCheatItemsEnabled();
                    if (this.worldConfig.isCheatItemsEnabled()) {
                        IConnectionToServer serverConnection = Internal.getServerConnection();
                        serverConnection.sendPacketToServer((PacketJei)new PacketRequestCheatPermission());
                    }
                } else {
                    ConfigButton.openSettings();
                }
            }
            return true;
        }
        return false;
    }

    private static void openSettings() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        IPlatformConfigHelper configHelper = Services.PLATFORM.getConfigHelper();
        Optional configScreen = configHelper.getConfigScreen();
        if (configScreen.isPresent()) {
            mc.setScreen((Screen)configScreen.get());
        } else {
            Component message = ConfigButton.getMissingConfigScreenMessage(configHelper);
            mc.player.displayClientMessage(message, false);
        }
    }

    private static Component getMissingConfigScreenMessage(IPlatformConfigHelper configHelper) {
        return Component.translatable((String)"jei.message.configured").setStyle(Style.EMPTY.withColor(ChatFormatting.DARK_BLUE).withUnderlined(Boolean.valueOf(true)).withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.curseforge.com/minecraft/mc-mods/configured"))).append("\n").append((Component)Component.translatable((String)"jei.message.config.folder").setStyle(Style.EMPTY.withColor(ChatFormatting.WHITE).withUnderlined(Boolean.valueOf(true)).withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_FILE, configHelper.createJeiConfigDir().toAbsolutePath().toString()))));
    }
}

