/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.config;

import java.nio.file.Path;
import mezz.jei.common.config.file.ConfigSchemaBuilder;
import mezz.jei.common.config.file.IConfigSchema;
import mezz.jei.common.config.file.IConfigSchemaBuilder;
import mezz.jei.gui.config.ClientConfig;
import mezz.jei.gui.config.IClientConfig;
import mezz.jei.gui.config.IIngredientFilterConfig;
import mezz.jei.gui.config.IIngredientGridConfig;
import mezz.jei.gui.config.IJeiClientConfigs;
import mezz.jei.gui.config.IngredientFilterConfig;
import mezz.jei.gui.config.IngredientGridConfig;
import mezz.jei.gui.util.HorizontalAlignment;

public class JeiClientConfigs
implements IJeiClientConfigs {
    private final IClientConfig clientConfig;
    private final IIngredientFilterConfig ingredientFilterConfig;
    private final IIngredientGridConfig ingredientListConfig;
    private final IIngredientGridConfig bookmarkListConfig;
    private final IConfigSchema schema;

    public JeiClientConfigs(Path configFile) {
        ConfigSchemaBuilder builder = new ConfigSchemaBuilder(configFile);
        this.clientConfig = new ClientConfig((IConfigSchemaBuilder)builder);
        this.ingredientFilterConfig = new IngredientFilterConfig((IConfigSchemaBuilder)builder);
        this.ingredientListConfig = new IngredientGridConfig("IngredientList", (IConfigSchemaBuilder)builder, HorizontalAlignment.RIGHT);
        this.bookmarkListConfig = new IngredientGridConfig("BookmarkList", (IConfigSchemaBuilder)builder, HorizontalAlignment.LEFT);
        this.schema = builder.build();
    }

    public void register() {
        this.schema.register();
    }

    @Override
    public IClientConfig getClientConfig() {
        return this.clientConfig;
    }

    @Override
    public IIngredientFilterConfig getIngredientFilterConfig() {
        return this.ingredientFilterConfig;
    }

    @Override
    public IIngredientGridConfig getIngredientListConfig() {
        return this.ingredientListConfig;
    }

    @Override
    public IIngredientGridConfig getBookmarkListConfig() {
        return this.bookmarkListConfig;
    }
}

