/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.debug;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IAdvancedRegistration;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IClickableIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.common.config.DebugConfig;
import mezz.jei.common.platform.IPlatformFluidHelperInternal;
import mezz.jei.common.platform.IPlatformRegistry;
import mezz.jei.common.platform.IPlatformScreenHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.common.util.MathUtil;
import mezz.jei.library.plugins.debug.DebugCategoryDecorator;
import mezz.jei.library.plugins.debug.DebugFocusRecipeCategory;
import mezz.jei.library.plugins.debug.DebugGhostIngredientHandler;
import mezz.jei.library.plugins.debug.DebugRecipe;
import mezz.jei.library.plugins.debug.DebugRecipeCategory;
import mezz.jei.library.plugins.debug.FluidSubtypeHandlerTest;
import mezz.jei.library.plugins.jei.ingredients.DebugIngredient;
import mezz.jei.library.plugins.jei.ingredients.DebugIngredientHelper;
import mezz.jei.library.plugins.jei.ingredients.DebugIngredientListFactory;
import mezz.jei.library.plugins.jei.ingredients.DebugIngredientRenderer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.BrewingStandScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

@JeiPlugin
public class JeiDebugPlugin
implements IModPlugin {
    @Nullable
    private DebugRecipeCategory<?> debugRecipeCategory;

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("jei", "debug");
    }

    public void registerIngredients(IModIngredientRegistration registration) {
        if (DebugConfig.isDebugModeEnabled()) {
            DebugIngredientHelper ingredientHelper = new DebugIngredientHelper();
            DebugIngredientRenderer ingredientRenderer = new DebugIngredientRenderer(ingredientHelper);
            registration.register(DebugIngredient.TYPE, Collections.emptyList(), (IIngredientHelper)ingredientHelper, (IIngredientRenderer)ingredientRenderer);
        }
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        if (DebugConfig.isDebugModeEnabled()) {
            IJeiHelpers jeiHelpers = registration.getJeiHelpers();
            IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
            IPlatformFluidHelper platformFluidHelper = jeiHelpers.getPlatformFluidHelper();
            IIngredientManager ingredientManager = jeiHelpers.getIngredientManager();
            this.debugRecipeCategory = new DebugRecipeCategory(guiHelper, platformFluidHelper, ingredientManager);
            registration.addRecipeCategories(new IRecipeCategory[]{this.debugRecipeCategory, new DebugFocusRecipeCategory(guiHelper, platformFluidHelper)});
        }
    }

    public void registerRecipes(IRecipeRegistration registration) {
        if (DebugConfig.isDebugModeEnabled()) {
            registration.addItemStackInfo(List.of(new ItemStack((ItemLike)Blocks.OAK_DOOR), new ItemStack((ItemLike)Blocks.SPRUCE_DOOR), new ItemStack((ItemLike)Blocks.BIRCH_DOOR), new ItemStack((ItemLike)Blocks.JUNGLE_DOOR), new ItemStack((ItemLike)Blocks.ACACIA_DOOR), new ItemStack((ItemLike)Blocks.DARK_OAK_DOOR)), new Component[]{Component.translatable((String)"description.jei.wooden.door.1"), Component.translatable((String)"description.jei.wooden.door.2"), Component.translatable((String)"description.jei.wooden.door.3")});
            IJeiHelpers jeiHelpers = registration.getJeiHelpers();
            IPlatformFluidHelper platformFluidHelper = jeiHelpers.getPlatformFluidHelper();
            this.registerFluidRecipes(registration, platformFluidHelper);
            registration.addIngredientInfo((Object)new DebugIngredient(1), DebugIngredient.TYPE, new Component[]{Component.literal((String)"debug")});
            registration.addIngredientInfo((Object)new DebugIngredient(2), DebugIngredient.TYPE, new Component[]{Component.literal((String)"debug colored").withStyle(ChatFormatting.AQUA), Component.literal((String)"debug\\nSplit and colored").withStyle(ChatFormatting.LIGHT_PURPLE), Component.translatable((String)"description.jei.debug.formatting.1", (Object[])new Object[]{"various"}), Component.translatable((String)"description.jei.debug.formatting.1", (Object[])new Object[]{"various\\nsplit"}), Component.translatable((String)"description.jei.debug.formatting.1", (Object[])new Object[]{Component.literal((String)"various colored").withStyle(ChatFormatting.RED)}), Component.translatable((String)"description.jei.debug.formatting.1", (Object[])new Object[]{Component.literal((String)"various\\nsplit colored").withStyle(ChatFormatting.DARK_AQUA)}), Component.translatable((String)"description.jei.debug.formatting.1", (Object[])new Object[]{"\\nSplitting at the start"}), Component.translatable((String)"description.jei.debug.formatting.1", (Object[])new Object[]{"various all colored"}).withStyle(ChatFormatting.RED), Component.translatable((String)"description.jei.debug.formatting.1", (Object[])new Object[]{Component.translatable((String)"description.jei.debug.formatting.3", (Object[])new Object[]{"various"}).withStyle(ChatFormatting.DARK_AQUA)}), Component.translatable((String)"description.jei.debug.formatting.2", (Object[])new Object[]{Component.literal((String)"multiple").withStyle(ChatFormatting.GOLD).withStyle(ChatFormatting.ITALIC), Component.literal((String)"various").withStyle(ChatFormatting.RED)}).withStyle(ChatFormatting.BLUE), Component.translatable((String)"description.jei.debug.formatting.1", (Object[])new Object[]{Component.translatable((String)"description.jei.debug.formatting.3", (Object[])new Object[]{Component.translatable((String)"description.jei.debug.formatting.2", (Object[])new Object[]{Component.literal((String)"multiple").withStyle(ChatFormatting.GOLD).withStyle(ChatFormatting.ITALIC), Component.literal((String)"various").withStyle(ChatFormatting.RED)}).withStyle(ChatFormatting.DARK_AQUA)})})});
            registration.addRecipes(DebugRecipeCategory.TYPE, List.of(new DebugRecipe(), new DebugRecipe()));
            registration.addRecipes(DebugFocusRecipeCategory.TYPE, List.of(new DebugRecipe()));
        }
    }

    private <T> void registerFluidRecipes(IRecipeRegistration registration, IPlatformFluidHelper<T> platformFluidHelper) {
        long bucketVolume = platformFluidHelper.bucketVolume();
        Object fluidIngredient = platformFluidHelper.create((Fluid)Fluids.WATER, bucketVolume, null);
        registration.addIngredientInfo(fluidIngredient, (IIngredientType)platformFluidHelper.getFluidIngredientType(), new Component[]{Component.literal((String)"water")});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        if (DebugConfig.isDebugModeEnabled()) {
            IJeiHelpers jeiHelpers = registration.getJeiHelpers();
            final IIngredientManager ingredientManager = jeiHelpers.getIngredientManager();
            registration.addGuiContainerHandler(BrewingStandScreen.class, (IGuiContainerHandler)new IGuiContainerHandler<BrewingStandScreen>(){

                public List<Rect2i> getGuiExtraAreas(BrewingStandScreen containerScreen) {
                    int widthMovement = (int)(System.currentTimeMillis() / 100L % 100L);
                    int size = 25 + widthMovement;
                    IPlatformScreenHelper screenHelper = Services.PLATFORM.getScreenHelper();
                    int guiLeft = screenHelper.getGuiLeft((AbstractContainerScreen)containerScreen);
                    int xSize = screenHelper.getXSize((AbstractContainerScreen)containerScreen);
                    int guiTop = screenHelper.getGuiTop((AbstractContainerScreen)containerScreen);
                    return List.of(new Rect2i(guiLeft + xSize, guiTop + 40, size, size));
                }

                public Optional<IClickableIngredient<?>> getClickableIngredientUnderMouse(BrewingStandScreen containerScreen, double mouseX, double mouseY) {
                    Rect2i area = new Rect2i(0, 0, 10, 10);
                    if (MathUtil.contains((Rect2i)area, (double)mouseX, (double)mouseY)) {
                        return ingredientManager.createTypedIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Items.BOW)).map(item -> new DebugClickableIngredient(item, area));
                    }
                    return Optional.empty();
                }
            });
            registration.addGhostIngredientHandler(BrewingStandScreen.class, new DebugGhostIngredientHandler(ingredientManager));
        }
    }

    public <T> void registerFluidSubtypes(ISubtypeRegistration registration, IPlatformFluidHelper<T> platformFluidHelper) {
        FlowingFluid water = Fluids.WATER;
        IIngredientTypeWithSubtypes ingredientType = platformFluidHelper.getFluidIngredientType();
        FluidSubtypeHandlerTest subtype = new FluidSubtypeHandlerTest(ingredientType);
        registration.registerSubtypeInterpreter(ingredientType, (Object)water, subtype);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        if (DebugConfig.isDebugModeEnabled()) {
            IPlatformFluidHelperInternal fluidHelper = Services.PLATFORM.getFluidHelper();
            this.registerRecipeCatalysts(registration, (IPlatformFluidHelper)fluidHelper);
        }
    }

    private <T> void registerRecipeCatalysts(IRecipeCatalystRegistration registration, IPlatformFluidHelper<T> fluidHelper) {
        long bucketVolume = fluidHelper.bucketVolume();
        registration.addRecipeCatalyst(DebugIngredient.TYPE, (Object)new DebugIngredient(7), new RecipeType[]{DebugRecipeCategory.TYPE});
        registration.addRecipeCatalyst((IIngredientType)fluidHelper.getFluidIngredientType(), fluidHelper.create((Fluid)Fluids.WATER, bucketVolume, null), new RecipeType[]{DebugRecipeCategory.TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Items.STICK), new RecipeType[]{DebugRecipeCategory.TYPE});
        IPlatformRegistry registry = Services.PLATFORM.getRegistry(Registry.ITEM_REGISTRY);
        registry.getValues().limit(30L).forEach(item -> {
            ItemStack catalystIngredient = new ItemStack((ItemLike)item);
            if (!catalystIngredient.isEmpty()) {
                registration.addRecipeCatalyst(catalystIngredient, new RecipeType[]{DebugRecipeCategory.TYPE});
            }
        });
    }

    public void registerAdvanced(IAdvancedRegistration registration) {
        if (DebugConfig.isDebugModeEnabled()) {
            registration.getJeiHelpers().getAllRecipeTypes().filter(r -> r.getUid().getNamespace().equals("jei")).forEach(r -> registration.addRecipeCategoryDecorator(r, DebugCategoryDecorator.getInstance()));
        }
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        if (DebugConfig.isDebugModeEnabled()) {
            ErrorUtil.assertMainThread();
            if (this.debugRecipeCategory != null) {
                this.debugRecipeCategory.setRuntime(jeiRuntime);
            }
            IIngredientManager ingredientManager = jeiRuntime.getIngredientManager();
            ingredientManager.addIngredientsAtRuntime(DebugIngredient.TYPE, DebugIngredientListFactory.create());
        }
    }

    private static class DebugClickableIngredient<T>
    implements IClickableIngredient<T> {
        private final ITypedIngredient<T> typedIngredient;
        private final Rect2i area;

        public DebugClickableIngredient(ITypedIngredient<T> typedIngredient, Rect2i area) {
            this.typedIngredient = typedIngredient;
            this.area = area;
        }

        public ITypedIngredient<T> getTypedIngredient() {
            return this.typedIngredient;
        }

        public Rect2i getArea() {
            return this.area;
        }
    }
}

