/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.vanilla.IJeiBrewingRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.platform.IPlatformIngredientHelper;
import mezz.jei.common.platform.IPlatformRegistry;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.library.ingredients.IngredientSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BrewingRecipeMakerCommon {
    private static final Logger LOGGER = LogManager.getLogger();

    public static Set<IJeiBrewingRecipe> getVanillaBrewingRecipes(IVanillaRecipeFactory recipeFactory, IIngredientManager ingredientManager, IVanillaPotionOutputSupplier vanillaOutputSupplier) {
        boolean foundNewPotions;
        HashSet<IJeiBrewingRecipe> recipes = new HashSet<IJeiBrewingRecipe>();
        IPlatformRegistry potionRegistry = Services.PLATFORM.getRegistry(Registry.POTION_REGISTRY);
        IngredientSet<ItemStack> knownPotions = BrewingRecipeMakerCommon.getBaseKnownPotions(ingredientManager, (IPlatformRegistry<Potion>)potionRegistry);
        List<ItemStack> potionReagents = ingredientManager.getAllItemStacks().stream().filter(BrewingRecipeMakerCommon::isIngredient).toList();
        do {
            List<ItemStack> newPotions;
            foundNewPotions = !(newPotions = BrewingRecipeMakerCommon.getNewPotions(recipeFactory, (IPlatformRegistry<Potion>)potionRegistry, knownPotions, potionReagents, vanillaOutputSupplier, recipes)).isEmpty();
            knownPotions.addAll(newPotions);
        } while (foundNewPotions);
        return recipes;
    }

    private static boolean isIngredient(ItemStack itemStack) {
        try {
            return PotionBrewing.isIngredient((ItemStack)itemStack);
        }
        catch (LinkageError | RuntimeException e) {
            String itemStackInfo = ErrorUtil.getItemStackInfo((ItemStack)itemStack);
            LOGGER.error("Failed to check if item is a potion reagent {}.", (Object)itemStackInfo, (Object)e);
            return false;
        }
    }

    private static IngredientSet<ItemStack> getBaseKnownPotions(IIngredientManager ingredientManager, IPlatformRegistry<Potion> potionRegistry) {
        IPlatformIngredientHelper ingredientHelper = Services.PLATFORM.getIngredientHelper();
        List potionContainers = ingredientHelper.getPotionContainers().stream().flatMap(potionItem -> Arrays.stream(potionItem.getItems())).toList();
        IIngredientHelper itemStackHelper = ingredientManager.getIngredientHelper((IIngredientType)VanillaTypes.ITEM_STACK);
        IngredientSet<ItemStack> knownPotions = IngredientSet.create(itemStackHelper, UidContext.Ingredient);
        potionRegistry.getValues().filter(potion -> potion != Potions.EMPTY).forEach(potion -> {
            for (ItemStack potionContainer : potionContainers) {
                ItemStack result = PotionUtils.setPotion((ItemStack)potionContainer.copy(), (Potion)potion);
                knownPotions.add(result);
            }
        });
        return knownPotions;
    }

    private static List<ItemStack> getNewPotions(IVanillaRecipeFactory recipeFactory, IPlatformRegistry<Potion> potionRegistry, Collection<ItemStack> knownPotions, List<ItemStack> potionReagents, IVanillaPotionOutputSupplier vanillaOutputSupplier, Collection<IJeiBrewingRecipe> recipes) {
        ArrayList<ItemStack> newPotions = new ArrayList<ItemStack>();
        for (ItemStack potionInput : knownPotions) {
            for (ItemStack potionReagent : potionReagents) {
                IJeiBrewingRecipe recipe;
                ResourceLocation outputId;
                Potion potionInputType;
                ResourceLocation inputId;
                Potion potionOutputType;
                ItemStack potionOutput = vanillaOutputSupplier.getOutput(potionInput.copy(), potionReagent);
                if (potionOutput.isEmpty() || potionInput.getItem() == potionOutput.getItem() && ((potionOutputType = PotionUtils.getPotion((ItemStack)potionOutput)) == Potions.WATER || Objects.equals(inputId = (ResourceLocation)potionRegistry.getRegistryName((Object)(potionInputType = PotionUtils.getPotion((ItemStack)potionInput))).orElse(null), outputId = (ResourceLocation)potionRegistry.getRegistryName((Object)potionOutputType).orElse(null))) || recipes.contains(recipe = recipeFactory.createBrewingRecipe(List.of(potionReagent), potionInput.copy(), potionOutput))) continue;
                recipes.add(recipe);
                newPotions.add(potionOutput);
            }
        }
        return newPotions;
    }

    @FunctionalInterface
    public static interface IVanillaPotionOutputSupplier {
        public ItemStack getOutput(ItemStack var1, ItemStack var2);
    }
}

