/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.ingredients;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.core.util.WeakList;
import mezz.jei.library.ingredients.IngredientInfo;
import mezz.jei.library.ingredients.RegisteredIngredients;
import mezz.jei.library.ingredients.TypedIngredient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Unmodifiable;

public class IngredientManager
implements IIngredientManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private final RegisteredIngredients registeredIngredients;
    private final WeakList<IIngredientManager.IIngredientListener> listeners = new WeakList();

    public IngredientManager(RegisteredIngredients registeredIngredients) {
        this.registeredIngredients = registeredIngredients;
    }

    public <V> @Unmodifiable Collection<V> getAllIngredients(IIngredientType<V> ingredientType) {
        ErrorUtil.checkNotNull(ingredientType, (String)"ingredientType");
        return this.registeredIngredients.getIngredientInfo(ingredientType).getAllIngredients();
    }

    public <V> IIngredientHelper<V> getIngredientHelper(V ingredient) {
        return this.getIngredientTypeChecked(ingredient).map(this::getIngredientHelper).orElseThrow(() -> new IllegalArgumentException("Unknown ingredient class: " + ingredient.getClass()));
    }

    public <V> IIngredientHelper<V> getIngredientHelper(IIngredientType<V> ingredientType) {
        ErrorUtil.checkNotNull(ingredientType, (String)"ingredientType");
        return this.registeredIngredients.getIngredientInfo(ingredientType).getIngredientHelper();
    }

    public <V> IIngredientRenderer<V> getIngredientRenderer(V ingredient) {
        return this.getIngredientTypeChecked(ingredient).map(this::getIngredientRenderer).orElseThrow(() -> new IllegalArgumentException("Unknown ingredient class: " + ingredient.getClass()));
    }

    public <V> IIngredientRenderer<V> getIngredientRenderer(IIngredientType<V> ingredientType) {
        ErrorUtil.checkNotNull(ingredientType, (String)"ingredientType");
        return this.registeredIngredients.getIngredientInfo(ingredientType).getIngredientRenderer();
    }

    public Collection<IIngredientType<?>> getRegisteredIngredientTypes() {
        return this.registeredIngredients.getIngredientTypes();
    }

    public <V> void addIngredientsAtRuntime(IIngredientType<V> ingredientType, Collection<V> ingredients) {
        ErrorUtil.assertMainThread();
        ErrorUtil.checkNotNull(ingredientType, (String)"ingredientType");
        ErrorUtil.checkNotEmpty(ingredients, (String)"ingredients");
        IngredientInfo<V> ingredientInfo = this.registeredIngredients.getIngredientInfo(ingredientType);
        LOGGER.info("Ingredients are being added at runtime: {} {}", (Object)ingredients.size(), (Object)ingredientType.getIngredientClass().getName());
        IIngredientHelper ingredientHelper = ingredientInfo.getIngredientHelper();
        List<Object> validIngredients = ingredients.stream().filter(i -> {
            if (!ingredientHelper.isValidIngredient(i)) {
                String errorInfo = ingredientHelper.getErrorInfo(i);
                LOGGER.error("Attempted to add an invalid Ingredient: {}", (Object)errorInfo);
                return false;
            }
            if (!ingredientHelper.isIngredientOnServer(i)) {
                String errorInfo = ingredientHelper.getErrorInfo(i);
                LOGGER.error("Attempted to add an Ingredient that is not on the server: {}", (Object)errorInfo);
                return false;
            }
            return true;
        }).toList();
        ingredientInfo.addIngredients(validIngredients);
        if (!this.listeners.isEmpty()) {
            List<ITypedIngredient> typedIngredients = validIngredients.stream().map(i -> TypedIngredient.createUnvalidated(ingredientType, i)).toList();
            this.listeners.forEach(listener -> listener.onIngredientsAdded(ingredientHelper, (Collection)typedIngredients));
        }
    }

    public <V> Optional<IIngredientType<V>> getIngredientTypeChecked(V ingredient) {
        ErrorUtil.checkNotNull(ingredient, (String)"ingredient");
        return this.registeredIngredients.getIngredientType(ingredient);
    }

    public <V> Optional<IIngredientType<V>> getIngredientTypeChecked(Class<? extends V> ingredientClass) {
        ErrorUtil.checkNotNull(ingredientClass, (String)"ingredientClass");
        return this.registeredIngredients.getIngredientType(ingredientClass);
    }

    public <V> IIngredientType<V> getIngredientType(V ingredient) {
        return this.getIngredientTypeChecked(ingredient).orElseThrow(() -> new IllegalArgumentException("Unknown ingredient class: " + ingredient.getClass()));
    }

    public <V> IIngredientType<V> getIngredientType(Class<? extends V> ingredientClass) {
        Optional<IIngredientType<V>> ingredientType = this.getIngredientTypeChecked(ingredientClass);
        return ingredientType.orElseThrow(() -> new IllegalArgumentException("Unknown ingredient class: " + ingredientClass));
    }

    public <V> void removeIngredientsAtRuntime(IIngredientType<V> ingredientType, Collection<V> ingredients) {
        ErrorUtil.assertMainThread();
        ErrorUtil.checkNotNull(ingredientType, (String)"ingredientType");
        ErrorUtil.checkNotEmpty(ingredients, (String)"ingredients");
        IngredientInfo<V> ingredientInfo = this.registeredIngredients.getIngredientInfo(ingredientType);
        LOGGER.info("Ingredients are being removed at runtime: {} {}", (Object)ingredients.size(), (Object)ingredientType.getIngredientClass().getName());
        ingredientInfo.removeIngredients(ingredients);
        if (!this.listeners.isEmpty()) {
            List typedIngredients = ingredients.stream().flatMap(i -> TypedIngredient.createAndFilterInvalid(this, ingredientType, i, false).stream()).toList();
            IIngredientHelper ingredientHelper = ingredientInfo.getIngredientHelper();
            this.listeners.forEach(listener -> listener.onIngredientsRemoved(ingredientHelper, (Collection)typedIngredients));
        }
    }

    public void registerIngredientListener(IIngredientManager.IIngredientListener listener) {
        ErrorUtil.checkNotNull((Object)listener, (String)"listener");
        this.listeners.add((Object)listener);
    }

    public <V> Optional<ITypedIngredient<V>> createTypedIngredient(IIngredientType<V> ingredientType, V ingredient) {
        return TypedIngredient.createAndFilterInvalid(this, ingredientType, ingredient, false);
    }

    public <V> ITypedIngredient<V> normalizeTypedIngredient(ITypedIngredient<V> typedIngredient) {
        ErrorUtil.checkNotNull(typedIngredient, (String)"typedIngredient");
        IIngredientType type = typedIngredient.getType();
        IIngredientHelper<V> ingredientHelper = this.getIngredientHelper(type);
        return TypedIngredient.normalize(typedIngredient, ingredientHelper);
    }

    @Deprecated
    public <V> Optional<V> getIngredientByUid(IIngredientType<V> ingredientType, String ingredientUuid) {
        return this.registeredIngredients.getIngredientInfo(ingredientType).getIngredientByUid(ingredientUuid);
    }
}

