/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.load.registration;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import mezz.jei.api.helpers.IColorHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.ISubtypeManager;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.library.ingredients.IngredientInfo;
import mezz.jei.library.ingredients.IngredientManager;
import mezz.jei.library.ingredients.RegisteredIngredients;

public class IngredientManagerBuilder
implements IModIngredientRegistration {
    private final List<IngredientInfo<?>> ingredientInfos = new ArrayList();
    private final Set<IIngredientType<?>> registeredIngredientSet = Collections.newSetFromMap(new IdentityHashMap());
    private final ISubtypeManager subtypeManager;
    private final IColorHelper colorHelper;

    public IngredientManagerBuilder(ISubtypeManager subtypeManager, IColorHelper colorHelper) {
        this.subtypeManager = subtypeManager;
        this.colorHelper = colorHelper;
    }

    public <V> void register(IIngredientType<V> ingredientType, Collection<V> allIngredients, IIngredientHelper<V> ingredientHelper, IIngredientRenderer<V> ingredientRenderer) {
        ErrorUtil.checkNotNull(ingredientType, (String)"ingredientType");
        ErrorUtil.checkNotNull(allIngredients, (String)"allIngredients");
        ErrorUtil.checkNotNull(ingredientHelper, (String)"ingredientHelper");
        ErrorUtil.checkNotNull(ingredientRenderer, (String)"ingredientRenderer");
        Preconditions.checkArgument((ingredientRenderer.getWidth() == 16 ? 1 : 0) != 0, (Object)"the default ingredient renderer registered here will be used for drawing ingredients in the ingredient list, and it must have a width of 16");
        Preconditions.checkArgument((ingredientRenderer.getHeight() == 16 ? 1 : 0) != 0, (Object)"the default ingredient renderer registered here will be used for drawing ingredients in the ingredient list, and it must have a height of 16");
        if (this.registeredIngredientSet.contains(ingredientType)) {
            throw new IllegalArgumentException("Ingredient type has already been registered: " + ingredientType.getIngredientClass());
        }
        this.ingredientInfos.add(new IngredientInfo<V>(ingredientType, allIngredients, ingredientHelper, ingredientRenderer));
        this.registeredIngredientSet.add(ingredientType);
    }

    public ISubtypeManager getSubtypeManager() {
        return this.subtypeManager;
    }

    public IColorHelper getColorHelper() {
        return this.colorHelper;
    }

    public IIngredientManager build() {
        RegisteredIngredients registeredIngredients = new RegisteredIngredients(this.ingredientInfos);
        return new IngredientManager(registeredIngredients);
    }
}

