/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.gui.recipes;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IScalableDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.inputs.IJeiInputHandler;
import mezz.jei.api.gui.inputs.RecipeSlotUnderMouse;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.JeiTooltip;
import mezz.jei.common.gui.elements.DrawableNineSliceTexture;
import mezz.jei.common.util.ImmutablePoint2i;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.library.gui.recipes.RecipeLayoutInputHandler;
import mezz.jei.library.gui.recipes.ShapelessIcon;
import mezz.jei.library.gui.recipes.layout.builder.RecipeLayoutBuilder;
import net.minecraft.client.renderer.Rect2i;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class RecipeLayout<R>
implements IRecipeLayoutDrawable<R> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int DEFAULT_RECIPE_BORDER_PADDING = 4;
    public static final int RECIPE_BUTTON_SIZE = 13;
    public static final int RECIPE_BUTTON_SPACING = 2;
    private final IRecipeCategory<R> recipeCategory;
    private final List<IRecipeSlotDrawable> recipeCategorySlots;
    private final R recipe;
    private final IScalableDrawable recipeBackground;
    private final int recipeBorderPadding;
    private final ImmutableRect2i recipeTransferButtonArea;
    @Nullable
    private final ShapelessIcon shapelessIcon;
    private final RecipeLayoutInputHandler<R> inputHandler;
    private ImmutableRect2i area;

    public static <T> Optional<IRecipeLayoutDrawable<T>> create(IRecipeCategory<T> recipeCategory, T recipe, IFocusGroup focuses, IIngredientManager ingredientManager) {
        DrawableNineSliceTexture recipeBackground = Internal.getTextures().getRecipeBackground();
        return RecipeLayout.create(recipeCategory, recipe, focuses, ingredientManager, (IScalableDrawable)recipeBackground, 4);
    }

    public static <T> Optional<IRecipeLayoutDrawable<T>> create(IRecipeCategory<T> recipeCategory, T recipe, IFocusGroup focuses, IIngredientManager ingredientManager, IScalableDrawable recipeBackground, int recipeBorderPadding) {
        RecipeLayoutBuilder<T> builder = new RecipeLayoutBuilder<T>(recipeCategory, recipe, ingredientManager);
        try {
            recipeCategory.setRecipe(builder, recipe, focuses);
            RecipeLayout<T> recipeLayout = builder.buildRecipeLayout(focuses, recipeBackground, recipeBorderPadding);
            return Optional.of(recipeLayout);
        }
        catch (LinkageError | RuntimeException e) {
            LOGGER.error("Error caught from Recipe Category: {}", (Object)recipeCategory.getRecipeType(), (Object)e);
            return Optional.empty();
        }
    }

    public RecipeLayout(IRecipeCategory<R> recipeCategory, R recipe, IScalableDrawable recipeBackground, int recipeBorderPadding, @Nullable ShapelessIcon shapelessIcon, ImmutablePoint2i recipeTransferButtonPos, List<IRecipeSlotDrawable> recipeCategorySlots) {
        this.recipeCategory = recipeCategory;
        this.inputHandler = new RecipeLayoutInputHandler(this);
        this.recipeCategorySlots = recipeCategorySlots;
        this.recipeBorderPadding = recipeBorderPadding;
        this.area = new ImmutableRect2i(0, 0, recipeCategory.getWidth(), recipeCategory.getHeight());
        this.recipeTransferButtonArea = new ImmutableRect2i(recipeTransferButtonPos.x(), recipeTransferButtonPos.y(), 13, 13);
        this.recipe = recipe;
        this.recipeBackground = recipeBackground;
        this.shapelessIcon = shapelessIcon;
    }

    public void setPosition(int posX, int posY) {
        this.area = this.area.setPosition(posX, posY);
    }

    public void drawRecipe(PoseStack poseStack, int mouseX, int mouseY) {
        IDrawable background = this.recipeCategory.getBackground();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.recipeBackground.draw(poseStack, this.getRectWithBorder());
        double recipeMouseX = mouseX - this.area.getX();
        double recipeMouseY = mouseY - this.area.getY();
        IRecipeSlotsView recipeCategorySlotsView = () -> Collections.unmodifiableList(this.recipeCategorySlots);
        poseStack.pushPose();
        poseStack.translate((double)this.area.getX(), (double)this.area.getY(), 0.0);
        background.draw(poseStack);
        poseStack.pushPose();
        this.recipeCategory.draw(this.recipe, recipeCategorySlotsView, poseStack, recipeMouseX, recipeMouseY);
        for (IRecipeSlotDrawable slot : this.recipeCategorySlots) {
            slot.draw(poseStack);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
        if (this.shapelessIcon != null) {
            this.shapelessIcon.draw(poseStack);
        }
        poseStack.popPose();
        RenderSystem.disableBlend();
    }

    public void drawOverlays(PoseStack poseStack, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int recipeMouseX = mouseX - this.area.getX();
        int recipeMouseY = mouseY - this.area.getY();
        RenderSystem.disableBlend();
        IRecipeSlotsView recipeCategorySlotsView = () -> Collections.unmodifiableList(this.recipeCategorySlots);
        RecipeSlotUnderMouse hoveredSlotResult = this.getSlotUnderMouse(mouseX, mouseY).orElse(null);
        if (hoveredSlotResult != null) {
            IRecipeSlotDrawable hoveredSlot = hoveredSlotResult.slot();
            poseStack.pushPose();
            poseStack.translate((double)hoveredSlotResult.x(), (double)hoveredSlotResult.y(), 0.0);
            hoveredSlot.drawHoverOverlays(poseStack);
            poseStack.popPose();
            JeiTooltip tooltip = new JeiTooltip();
            tooltip.addAll((Collection)hoveredSlot.getTooltip());
            tooltip.draw(poseStack, mouseX, mouseY);
        } else if (this.isMouseOver(mouseX, mouseY)) {
            JeiTooltip tooltip = new JeiTooltip();
            tooltip.addAll((Collection)this.recipeCategory.getTooltipStrings(this.recipe, recipeCategorySlotsView, (double)recipeMouseX, (double)recipeMouseY));
            if (tooltip.isEmpty() && this.shapelessIcon != null && this.shapelessIcon.isMouseOver(recipeMouseX, recipeMouseY)) {
                this.shapelessIcon.addTooltip(tooltip);
            }
            tooltip.draw(poseStack, mouseX, mouseY);
        }
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.area.contains(mouseX, mouseY);
    }

    public Rect2i getRect() {
        return this.area.toMutable();
    }

    public Rect2i getRectWithBorder() {
        return this.area.expandBy(this.recipeBorderPadding).toMutable();
    }

    public <T> Optional<T> getIngredientUnderMouse(int mouseX, int mouseY, IIngredientType<T> ingredientType) {
        return this.getSlotUnderMouse(mouseX, mouseY).map(RecipeSlotUnderMouse::slot).flatMap(slot -> slot.getDisplayedIngredient(ingredientType));
    }

    public Optional<IRecipeSlotDrawable> getRecipeSlotUnderMouse(double mouseX, double mouseY) {
        return this.getSlotUnderMouse(mouseX, mouseY).map(RecipeSlotUnderMouse::slot);
    }

    public Optional<RecipeSlotUnderMouse> getSlotUnderMouse(double mouseX, double mouseY) {
        double recipeMouseX = mouseX - (double)this.area.getX();
        double recipeMouseY = mouseY - (double)this.area.getY();
        for (IRecipeSlotDrawable slot : this.recipeCategorySlots) {
            if (!slot.isMouseOver(recipeMouseX, recipeMouseY)) continue;
            return Optional.of(new RecipeSlotUnderMouse(slot, this.area.getX(), this.area.getY()));
        }
        return Optional.empty();
    }

    public IRecipeCategory<R> getRecipeCategory() {
        return this.recipeCategory;
    }

    public Rect2i getRecipeTransferButtonArea() {
        return this.recipeTransferButtonArea.toMutable();
    }

    public IRecipeSlotsView getRecipeSlotsView() {
        return () -> Collections.unmodifiableList(this.recipeCategorySlots);
    }

    public R getRecipe() {
        return this.recipe;
    }

    public IJeiInputHandler getInputHandler() {
        return this.inputHandler;
    }
}

