/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.gui.recipes;

import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.Internal;
import mezz.jei.common.util.ErrorUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class OutputSlotTooltipCallback
implements IRecipeSlotTooltipCallback {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ResourceLocation recipeName;

    public OutputSlotTooltipCallback(ResourceLocation recipeName) {
        this.recipeName = recipeName;
    }

    public void onTooltip(IRecipeSlotView recipeSlotView, List<Component> tooltip) {
        boolean showAdvanced;
        String recipeModId;
        String ingredientModId;
        if (recipeSlotView.getRole() != RecipeIngredientRole.OUTPUT) {
            return;
        }
        Optional displayedIngredient = recipeSlotView.getDisplayedIngredient();
        if (displayedIngredient.isEmpty()) {
            return;
        }
        IModIdHelper modIdHelper = Internal.getJeiRuntime().getJeiHelpers().getModIdHelper();
        if (modIdHelper.isDisplayingModNameEnabled() && (ingredientModId = this.getDisplayModId((ITypedIngredient)displayedIngredient.get())) != null && !(recipeModId = this.recipeName.getNamespace()).equals(ingredientModId)) {
            String modName = modIdHelper.getFormattedModNameForModId(recipeModId);
            MutableComponent recipeBy = Component.translatable((String)"jei.tooltip.recipe.by", (Object[])new Object[]{modName});
            tooltip.add((Component)recipeBy.withStyle(ChatFormatting.GRAY));
        }
        Minecraft minecraft = Minecraft.getInstance();
        boolean bl = showAdvanced = minecraft.options.advancedItemTooltips || Screen.hasShiftDown();
        if (showAdvanced) {
            MutableComponent recipeId = Component.translatable((String)"jei.tooltip.recipe.id", (Object[])new Object[]{Component.literal((String)this.recipeName.toString())});
            tooltip.add((Component)recipeId.withStyle(ChatFormatting.DARK_GRAY));
        }
    }

    @Nullable
    private <T> String getDisplayModId(ITypedIngredient<T> typedIngredient) {
        IIngredientManager ingredientManager = Internal.getJeiRuntime().getIngredientManager();
        IIngredientType type = typedIngredient.getType();
        Object ingredient = typedIngredient.getIngredient();
        IIngredientHelper ingredientHelper = ingredientManager.getIngredientHelper(type);
        try {
            return ingredientHelper.getDisplayModId(ingredient);
        }
        catch (RuntimeException e) {
            String ingredientInfo = ErrorUtil.getIngredientInfo((Object)ingredient, (IIngredientType)type, (IIngredientManager)ingredientManager);
            LOGGER.error("Caught exception from ingredient without a resource location: {}", (Object)ingredientInfo, (Object)e);
            return null;
        }
    }
}

