/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.gui.ingredients;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IIngredientVisibility;
import mezz.jei.common.Internal;
import mezz.jei.common.config.IClientConfig;
import mezz.jei.common.gui.JeiTooltip;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.SafeIngredientUtil;
import mezz.jei.library.gui.ingredients.ICycler;
import mezz.jei.library.gui.ingredients.RendererOverrides;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class RecipeSlot
implements IRecipeSlotView,
IRecipeSlotDrawable {
    private static final int MAX_DISPLAYED_INGREDIENTS = 100;
    private final RecipeIngredientRole role;
    private final ICycler cycler;
    private final List<IRecipeSlotTooltipCallback> tooltipCallbacks;
    @Nullable
    private final RendererOverrides rendererOverrides;
    @Nullable
    private final IDrawable background;
    @Nullable
    private final IDrawable overlay;
    @Nullable
    private final String slotName;
    private final ImmutableRect2i rect;
    private final @Unmodifiable List<Optional<ITypedIngredient<?>>> allIngredients;
    private @Unmodifiable @Nullable List<Optional<ITypedIngredient<?>>> displayIngredients;

    public RecipeSlot(RecipeIngredientRole role, ImmutableRect2i rect, ICycler cycler, List<IRecipeSlotTooltipCallback> tooltipCallbacks, List<Optional<ITypedIngredient<?>>> allIngredients, @Nullable List<Optional<ITypedIngredient<?>>> focusedIngredients, @Nullable IDrawable background, @Nullable IDrawable overlay, @Nullable String slotName, @Nullable RendererOverrides rendererOverrides) {
        this.allIngredients = List.copyOf(allIngredients);
        this.background = background;
        this.overlay = overlay;
        this.slotName = slotName;
        this.rendererOverrides = rendererOverrides;
        this.role = role;
        this.rect = rect;
        this.cycler = cycler;
        this.displayIngredients = focusedIngredients;
        this.tooltipCallbacks = tooltipCallbacks;
    }

    public Stream<ITypedIngredient<?>> getAllIngredients() {
        return this.allIngredients.stream().flatMap(Optional::stream);
    }

    public Optional<ITypedIngredient<?>> getDisplayedIngredient() {
        if (this.displayIngredients == null) {
            this.displayIngredients = RecipeSlot.calculateDisplayIngredients(this.allIngredients);
        }
        return this.cycler.getCycled(this.displayIngredients);
    }

    private static List<Optional<ITypedIngredient<?>>> calculateDisplayIngredients(List<Optional<ITypedIngredient<?>>> allIngredients) {
        if (allIngredients.isEmpty()) {
            return List.of();
        }
        List<Optional<ITypedIngredient<?>>> visibleIngredients = List.of();
        boolean hasInvisibleIngredients = false;
        IIngredientVisibility ingredientVisibility = Internal.getJeiRuntime().getIngredientVisibility();
        for (int i = 0; i < allIngredients.size() && visibleIngredients.size() < 100; ++i) {
            boolean visible;
            Optional<ITypedIngredient<?>> ingredient = allIngredients.get(i);
            boolean bl = visible = ingredient.isEmpty() || ingredientVisibility.isIngredientVisible(ingredient.get());
            if (visible) {
                if (!hasInvisibleIngredients) continue;
                visibleIngredients.add(ingredient);
                continue;
            }
            if (hasInvisibleIngredients) continue;
            hasInvisibleIngredients = true;
            visibleIngredients = new ArrayList(allIngredients.subList(0, i));
        }
        if (!visibleIngredients.isEmpty()) {
            return visibleIngredients;
        }
        if (allIngredients.size() < 100) {
            return allIngredients;
        }
        return allIngredients.subList(0, 100);
    }

    public Optional<String> getSlotName() {
        return Optional.ofNullable(this.slotName);
    }

    public RecipeIngredientRole getRole() {
        return this.role;
    }

    public void drawHighlight(PoseStack poseStack, int color) {
        int x = this.rect.getX();
        int y = this.rect.getY();
        int width = this.rect.getWidth();
        int height = this.rect.getHeight();
        RenderSystem.disableDepthTest();
        GuiComponent.fill((PoseStack)poseStack, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)color);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private <T> List<Component> legacyGetTooltip(ITypedIngredient<T> typedIngredient) {
        IIngredientManager ingredientManager = Internal.getJeiRuntime().getIngredientManager();
        IIngredientType ingredientType = typedIngredient.getType();
        IIngredientRenderer<T> ingredientRenderer = this.getIngredientRenderer(ingredientType);
        JeiTooltip tooltip = new JeiTooltip();
        SafeIngredientUtil.getTooltip((ITooltipBuilder)tooltip, (IIngredientManager)ingredientManager, ingredientRenderer, typedIngredient);
        this.addTagNameTooltip((ITooltipBuilder)tooltip, ingredientManager, typedIngredient);
        List legacyComponents = tooltip.getLegacyComponents();
        for (IRecipeSlotTooltipCallback tooltipCallback : this.tooltipCallbacks) {
            tooltipCallback.onTooltip((IRecipeSlotView)this, legacyComponents);
        }
        return legacyComponents;
    }

    private <T> void addTagNameTooltip(ITooltipBuilder tooltip, IIngredientManager ingredientManager, ITypedIngredient<T> ingredient) {
        IIngredientType ingredientType = ingredient.getType();
        List ingredients = this.getIngredients(ingredientType).toList();
        if (ingredients.isEmpty()) {
            return;
        }
        IClientConfig clientConfig = Internal.getJeiClientConfigs().getClientConfig();
        if (clientConfig.isHideSingleIngredientTagsEnabled() && ingredients.size() == 1) {
            return;
        }
        IIngredientHelper ingredientHelper = ingredientManager.getIngredientHelper(ingredientType);
        ingredientHelper.getTagKeyEquivalent(ingredients).ifPresent(tagKeyEquivalent -> {
            tooltip.add((Component)Component.translatable((String)"jei.tooltip.recipe.tag", (Object[])new Object[]{""}).withStyle(ChatFormatting.GRAY));
            MutableComponent tagName = Component.literal((String)tagKeyEquivalent.location().toString());
            tooltip.add((Component)tagName.copy().withStyle(ChatFormatting.GRAY));
        });
    }

    public void addTooltipCallback(IRecipeSlotTooltipCallback tooltipCallback) {
        this.tooltipCallbacks.add(tooltipCallback);
    }

    private <T> IIngredientRenderer<T> getIngredientRenderer(IIngredientType<T> ingredientType) {
        return Optional.ofNullable(this.rendererOverrides).flatMap(r -> r.getIngredientRenderer(ingredientType)).orElseGet(() -> {
            IIngredientManager ingredientManager = Internal.getJeiRuntime().getIngredientManager();
            return ingredientManager.getIngredientRenderer(ingredientType);
        });
    }

    public void draw(PoseStack poseStack) {
        int x = this.rect.getX();
        int y = this.rect.getY();
        if (this.background != null) {
            this.background.draw(poseStack, x, y);
        }
        RenderSystem.enableBlend();
        this.getDisplayedIngredient().ifPresent(ingredient -> this.drawIngredient(poseStack, (ITypedIngredient)ingredient, x, y));
        if (this.overlay != null) {
            RenderSystem.enableBlend();
            poseStack.pushPose();
            poseStack.translate(0.0, 0.0, 200.0);
            this.overlay.draw(poseStack, x, y);
            poseStack.popPose();
        }
        RenderSystem.disableBlend();
    }

    private <T> void drawIngredient(PoseStack poseStack, ITypedIngredient<T> typedIngredient, int xPos, int yPos) {
        IIngredientType ingredientType = typedIngredient.getType();
        Object ingredient = typedIngredient.getIngredient();
        IIngredientRenderer<T> ingredientRenderer = this.getIngredientRenderer(ingredientType);
        try {
            ingredientRenderer.render(poseStack, ingredient, xPos, yPos);
        }
        catch (LinkageError | RuntimeException e) {
            IIngredientManager ingredientManager = Internal.getJeiRuntime().getIngredientManager();
            throw ErrorUtil.createRenderIngredientException((Throwable)e, (Object)ingredient, (IIngredientManager)ingredientManager);
        }
    }

    public void drawHoverOverlays(PoseStack poseStack) {
        this.drawHighlight(poseStack, -2130706433);
    }

    public List<Component> getTooltip() {
        return this.getDisplayedIngredient().map(this::legacyGetTooltip).orElseGet(List::of);
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.rect.contains(mouseX, mouseY);
    }

    public Rect2i getRect() {
        return this.rect.toMutable();
    }

    public String toString() {
        return "RecipeSlot{rect=" + this.rect + "}";
    }
}

