/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import com.mojang.blaze3d.vertex.PoseStack;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.common.gui.JeiTooltip;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.MathUtil;
import mezz.jei.common.util.StringUtil;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class RecipeCategoryTitle {
    private final Component visibleString;
    private final Component fullString;
    private final ImmutableRect2i area;

    public static RecipeCategoryTitle create(IRecipeCategory<?> recipeCategory, Font font, ImmutableRect2i availableArea) {
        Component fullString = StringUtil.stripStyling((Component)recipeCategory.getTitle());
        int availableTitleWidth = availableArea.getWidth();
        Component visibleString = font.width((FormattedText)fullString) > availableTitleWidth ? StringUtil.truncateStringToWidth((Component)fullString, (int)availableTitleWidth, (Font)font) : fullString;
        ImmutableRect2i area = MathUtil.centerTextArea((ImmutableRect2i)availableArea, (Font)font, (FormattedText)visibleString);
        return new RecipeCategoryTitle(visibleString, fullString, area);
    }

    public RecipeCategoryTitle() {
        this((Component)Component.empty(), (Component)Component.empty(), ImmutableRect2i.EMPTY);
    }

    public RecipeCategoryTitle(Component visibleString, Component fullString, ImmutableRect2i area) {
        this.visibleString = visibleString;
        this.fullString = fullString;
        this.area = area;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.area.contains(mouseX, mouseY);
    }

    public void getTooltip(JeiTooltip tooltip) {
        if (!this.visibleString.equals(this.fullString)) {
            tooltip.add(this.fullString);
        }
    }

    public void draw(PoseStack poseStack, Font font) {
        StringUtil.drawCenteredStringWithShadow((PoseStack)poseStack, (Font)font, (Component)this.visibleString, (ImmutableRect2i)this.area);
    }
}

