/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.search;

import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import mezz.jei.core.search.CombinedSearchables;
import mezz.jei.core.search.ISearchStorage;
import mezz.jei.core.search.ISearchable;
import mezz.jei.core.search.PrefixInfo;
import mezz.jei.core.search.PrefixedSearchable;
import mezz.jei.core.search.SearchMode;
import mezz.jei.gui.ingredients.IListElement;
import mezz.jei.gui.ingredients.IListElementInfo;
import mezz.jei.gui.search.ElementPrefixParser;
import mezz.jei.gui.search.IElementSearch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ElementSearch
implements IElementSearch {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<PrefixInfo<IListElementInfo<?>, IListElement<?>>, PrefixedSearchable<IListElementInfo<?>, IListElement<?>>> prefixedSearchables = new IdentityHashMap();
    private final CombinedSearchables<IListElement<?>> combinedSearchables = new CombinedSearchables();

    public ElementSearch(ElementPrefixParser elementPrefixParser) {
        for (PrefixInfo<IListElementInfo<?>, IListElement<?>> prefixInfo : elementPrefixParser.allPrefixInfos()) {
            ISearchStorage storage = prefixInfo.createStorage();
            PrefixedSearchable prefixedSearchable = new PrefixedSearchable(storage, prefixInfo);
            this.prefixedSearchables.put(prefixInfo, prefixedSearchable);
            this.combinedSearchables.addSearchable((ISearchable)prefixedSearchable);
        }
    }

    @Override
    public Set<IListElement<?>> getSearchResults(ElementPrefixParser.TokenInfo tokenInfo) {
        ISearchable searchable;
        Set<IListElement<?>> results;
        String token;
        block6: {
            block5: {
                token = tokenInfo.token();
                if (token.isEmpty()) {
                    return Set.of();
                }
                results = Collections.newSetFromMap(new IdentityHashMap());
                PrefixInfo<IListElementInfo<?>, IListElement<?>> prefixInfo = tokenInfo.prefixInfo();
                if (prefixInfo == ElementPrefixParser.NO_PREFIX) {
                    this.combinedSearchables.getSearchResults(token, results::addAll);
                    return results;
                }
                searchable = (ISearchable)this.prefixedSearchables.get(prefixInfo);
                if (searchable == null) break block5;
                if (searchable.getMode() != SearchMode.DISABLED) break block6;
            }
            this.combinedSearchables.getSearchResults(token, results::addAll);
            return results;
        }
        searchable.getSearchResults(token, results::addAll);
        return results;
    }

    @Override
    public void add(IListElementInfo<?> info) {
        for (PrefixedSearchable<IListElementInfo<?>, IListElement<?>> prefixedSearchable : this.prefixedSearchables.values()) {
            SearchMode searchMode = prefixedSearchable.getMode();
            if (searchMode == SearchMode.DISABLED) continue;
            Collection strings = prefixedSearchable.getStrings(info);
            ISearchStorage storage = prefixedSearchable.getSearchStorage();
            for (String string : strings) {
                storage.put(string, info.getElement());
            }
        }
    }

    @Override
    public void addAll(Collection<IListElementInfo<?>> infos) {
        for (PrefixedSearchable<IListElementInfo<?>, IListElement<?>> prefixedSearchable : this.prefixedSearchables.values()) {
            SearchMode searchMode = prefixedSearchable.getMode();
            if (searchMode == SearchMode.DISABLED) continue;
            ISearchStorage storage = prefixedSearchable.getSearchStorage();
            for (IListElementInfo<?> info : infos) {
                Collection strings = prefixedSearchable.getStrings(info);
                for (String string : strings) {
                    storage.put(string, info.getElement());
                }
            }
        }
    }

    public Set<IListElement<?>> getAllIngredients() {
        Set<IListElement<?>> results = Collections.newSetFromMap(new IdentityHashMap());
        PrefixedSearchable<IListElementInfo<?>, IListElement<?>> noPrefixSearchables = this.prefixedSearchables.get(ElementPrefixParser.NO_PREFIX);
        noPrefixSearchables.getAllElements(results::addAll);
        return results;
    }

    @Override
    public void logStatistics() {
        this.prefixedSearchables.forEach((prefixInfo, value) -> {
            if (prefixInfo.getMode() != SearchMode.DISABLED) {
                ISearchStorage storage = value.getSearchStorage();
                LOGGER.info("ElementSearch {} Storage Stats: {}", prefixInfo, (Object)storage.statistics());
            }
        });
    }
}

