/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.config;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.util.ServerConfigPathUtil;
import mezz.jei.gui.bookmarks.BookmarkList;
import mezz.jei.gui.bookmarks.IBookmark;
import mezz.jei.gui.bookmarks.IngredientBookmark;
import mezz.jei.gui.config.IBookmarkConfig;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BookmarkConfig
implements IBookmarkConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String MARKER_OTHER = "O:";
    private static final String MARKER_STACK = "T:";
    private final Path jeiConfigurationDir;

    private static Optional<Path> getPath(Path jeiConfigurationDir) {
        return ServerConfigPathUtil.getWorldPath((Path)jeiConfigurationDir).flatMap(configPath -> {
            try {
                configPath = Files.createDirectories(configPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                LOGGER.error("Unable to create bookmark config folder: {}", configPath);
                return Optional.empty();
            }
            Path path = configPath.resolve("bookmarks.ini");
            return Optional.of(path);
        });
    }

    public BookmarkConfig(Path jeiConfigurationDir) {
        this.jeiConfigurationDir = jeiConfigurationDir;
    }

    @Override
    public void saveBookmarks(IIngredientManager ingredientManager, List<IBookmark> ingredientList) {
        BookmarkConfig.getPath(this.jeiConfigurationDir).ifPresent(path -> {
            ArrayList<CallSite> strings = new ArrayList<CallSite>();
            for (IBookmark bookmark : ingredientList) {
                ITypedIngredient<?> typedIngredient = bookmark.getElement().getTypedIngredient();
                Object patt2181$temp = typedIngredient.getIngredient();
                if (patt2181$temp instanceof ItemStack) {
                    ItemStack stack = (ItemStack)patt2181$temp;
                    strings.add((CallSite)((Object)(MARKER_STACK + stack.save(new CompoundTag()))));
                    continue;
                }
                strings.add((CallSite)((Object)(MARKER_OTHER + BookmarkConfig.getUid(ingredientManager, typedIngredient))));
            }
            try {
                Files.write(path, strings, new OpenOption[0]);
            }
            catch (IOException e) {
                LOGGER.error("Failed to save bookmarks list to file {}", path, (Object)e);
            }
        });
    }

    @Override
    public void loadBookmarks(IIngredientManager ingredientManager, BookmarkList bookmarkList) {
        BookmarkConfig.getPath(this.jeiConfigurationDir).ifPresent(path -> {
            List<String> ingredientJsonStrings;
            if (!Files.exists(path, new LinkOption[0])) {
                return;
            }
            try {
                ingredientJsonStrings = Files.readAllLines(path);
            }
            catch (IOException e) {
                LOGGER.error("Failed to load bookmarks from file {}", path, (Object)e);
                return;
            }
            List<IIngredientType<?>> otherIngredientTypes = ingredientManager.getRegisteredIngredientTypes().stream().filter(i -> !i.equals(VanillaTypes.ITEM_STACK)).toList();
            IIngredientHelper itemStackHelper = ingredientManager.getIngredientHelper((IIngredientType)VanillaTypes.ITEM_STACK);
            for (String ingredientJsonString : ingredientJsonStrings) {
                if (ingredientJsonString.startsWith(MARKER_STACK)) {
                    String itemStackAsJson = ingredientJsonString.substring(MARKER_STACK.length());
                    try {
                        CompoundTag itemStackAsNbt = TagParser.parseTag((String)itemStackAsJson);
                        ItemStack itemStack = ItemStack.of((CompoundTag)itemStackAsNbt);
                        if (!itemStack.isEmpty()) {
                            ItemStack normalized = (ItemStack)itemStackHelper.normalizeIngredient((Object)itemStack);
                            Optional typedIngredient = ingredientManager.createTypedIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)normalized);
                            if (typedIngredient.isEmpty()) {
                                LOGGER.warn("Failed to load bookmarked ItemStack from json string, the item no longer exists:\n{}", (Object)itemStackAsJson);
                                continue;
                            }
                            IngredientBookmark bookmark = IngredientBookmark.create((ITypedIngredient)typedIngredient.get(), ingredientManager);
                            bookmarkList.addToListWithoutNotifying(bookmark, false);
                            continue;
                        }
                        LOGGER.warn("Failed to load bookmarked ItemStack from json string, the item no longer exists:\n{}", (Object)itemStackAsJson);
                    }
                    catch (CommandSyntaxException e) {
                        LOGGER.error("Failed to load bookmarked ItemStack from json string:\n{}", (Object)itemStackAsJson, (Object)e);
                    }
                    continue;
                }
                if (ingredientJsonString.startsWith(MARKER_OTHER)) {
                    String uid = ingredientJsonString.substring(MARKER_OTHER.length());
                    Optional<ITypedIngredient<?>> typedIngredient = BookmarkConfig.getNormalizedIngredientByUid(ingredientManager, otherIngredientTypes, uid);
                    if (typedIngredient.isEmpty()) {
                        LOGGER.error("Failed to load unknown bookmarked ingredient:\n{}", (Object)ingredientJsonString);
                        continue;
                    }
                    IngredientBookmark<?> bookmark = IngredientBookmark.create(typedIngredient.get(), ingredientManager);
                    bookmarkList.addToListWithoutNotifying(bookmark, false);
                    continue;
                }
                LOGGER.error("Failed to load unknown bookmarked ingredient:\n{}", (Object)ingredientJsonString);
            }
            bookmarkList.notifyListenersOfChange();
        });
    }

    private static <T> String getUid(IIngredientManager ingredientManager, ITypedIngredient<T> typedIngredient) {
        IIngredientHelper ingredientHelper = ingredientManager.getIngredientHelper(typedIngredient.getType());
        return ingredientHelper.getUniqueId(typedIngredient.getIngredient(), UidContext.Ingredient);
    }

    private static Optional<ITypedIngredient<?>> getNormalizedIngredientByUid(IIngredientManager ingredientManager, Collection<IIngredientType<?>> ingredientTypes, String uid) {
        return ingredientTypes.stream().map(t -> BookmarkConfig.getNormalizedIngredientByUid(ingredientManager, t, uid)).flatMap(Optional::stream).findFirst();
    }

    private static <T> Optional<ITypedIngredient<?>> getNormalizedIngredientByUid(IIngredientManager ingredientManager, IIngredientType<T> ingredientType, String uid) {
        return ingredientManager.getIngredientByUid(ingredientType, uid).map(i -> {
            IIngredientHelper ingredientHelper = ingredientManager.getIngredientHelper(ingredientType);
            return ingredientHelper.normalizeIngredient(i);
        }).flatMap(i -> ingredientManager.createTypedIngredient(ingredientType, i));
    }
}

