/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.ingredients.rendering.BatchRenderElement;
import mezz.jei.api.runtime.IEditModeConfig;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.elements.OffsetDrawable;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.SafeIngredientUtil;
import mezz.jei.core.collect.ListMultiMap;
import mezz.jei.gui.overlay.IngredientListSlot;
import mezz.jei.gui.overlay.elements.IElement;
import net.minecraft.client.gui.GuiComponent;

public class IngredientListRenderer {
    private static final int BLACKLIST_COLOR = -570490880;
    private static final int WILDCARD_BLACKLIST_COLOR = -570448640;
    private final List<IngredientListSlot> slots = new ArrayList<IngredientListSlot>();
    private final ListMultiMap<IIngredientType<?>, BatchRenderElement<?>> renderElementsByType = new ListMultiMap();
    private final List<IDrawable> renderOverlays = new ArrayList<IDrawable>();
    private final IIngredientManager ingredientManager;
    private final boolean searchable;
    private int blocked = 0;

    public IngredientListRenderer(IIngredientManager ingredientManager, boolean searchable) {
        this.ingredientManager = ingredientManager;
        this.searchable = searchable;
    }

    public void clear() {
        this.slots.clear();
        this.renderElementsByType.clear();
        this.renderOverlays.clear();
        this.blocked = 0;
    }

    public int size() {
        return this.slots.size() - this.blocked;
    }

    public void add(IngredientListSlot ingredientListSlot) {
        this.slots.add(ingredientListSlot);
        this.addRenderElement(ingredientListSlot);
    }

    private void addRenderElement(IngredientListSlot ingredientListSlot) {
        ingredientListSlot.getOptionalElement().ifPresent(element -> {
            ITypedIngredient typedIngredient = element.getTypedIngredient();
            IIngredientType ingredientType = typedIngredient.getType();
            ImmutableRect2i renderArea = ingredientListSlot.getRenderArea();
            BatchRenderElement batchRenderElement = new BatchRenderElement(typedIngredient.getIngredient(), renderArea.getX(), renderArea.getY());
            this.renderElementsByType.put((Object)ingredientType, (Object)batchRenderElement);
            IDrawable renderOverlay = element.createRenderOverlay();
            if (renderOverlay != null) {
                this.renderOverlays.add(OffsetDrawable.create((IDrawable)renderOverlay, (int)renderArea.getX(), (int)renderArea.getY()));
            }
        });
    }

    public Stream<IngredientListSlot> getSlots() {
        return this.slots.stream().filter(s -> !s.isBlocked());
    }

    public void set(int startIndex, List<IElement<?>> ingredientList) {
        this.blocked = 0;
        this.renderElementsByType.clear();
        this.renderOverlays.clear();
        ListIterator<IElement<?>> elementIterator = ingredientList.listIterator(startIndex);
        for (IngredientListSlot ingredientListSlot : this.slots) {
            if (ingredientListSlot.isBlocked()) {
                ingredientListSlot.clear();
                ++this.blocked;
                continue;
            }
            if (elementIterator.hasNext()) {
                IElement<?> element = elementIterator.next();
                while (!element.isVisible() && elementIterator.hasNext()) {
                    element = elementIterator.next();
                }
                if (element.isVisible()) {
                    ingredientListSlot.setElement(element);
                    this.addRenderElement(ingredientListSlot);
                    continue;
                }
                ingredientListSlot.clear();
                continue;
            }
            ingredientListSlot.clear();
        }
    }

    public void render(PoseStack poseStack) {
        if (this.searchable && Internal.getWorldConfig().isEditModeEnabled()) {
            this.renderEditMode(poseStack);
        }
        for (Map.Entry entry : this.renderElementsByType.entrySet()) {
            this.renderBatch(poseStack, entry);
        }
        for (IDrawable overlay : this.renderOverlays) {
            overlay.draw(poseStack);
        }
    }

    private <T> void renderBatch(PoseStack poseStack, Map.Entry<IIngredientType<?>, List<BatchRenderElement<?>>> entry) {
        IIngredientType<?> type = entry.getKey();
        IIngredientRenderer ingredientRenderer = this.ingredientManager.getIngredientRenderer(type);
        List<BatchRenderElement<?>> elements = entry.getValue();
        SafeIngredientUtil.renderBatch((PoseStack)poseStack, type, (IIngredientRenderer)ingredientRenderer, elements);
    }

    private void renderEditMode(PoseStack poseStack) {
        IEditModeConfig editModeConfig = Internal.getJeiRuntime().getEditModeConfig();
        for (IngredientListSlot slot : this.slots) {
            slot.getOptionalElement().ifPresent(element -> IngredientListRenderer.renderEditMode(poseStack, slot.getArea(), slot.getPadding(), element.getTypedIngredient(), editModeConfig));
        }
        RenderSystem.enableBlend();
    }

    private static <T> void renderEditMode(PoseStack poseStack, ImmutableRect2i area, int padding, ITypedIngredient<T> typedIngredient, IEditModeConfig config) {
        Set hideModes = config.getIngredientHiddenUsingConfigFile(typedIngredient);
        if (!hideModes.isEmpty()) {
            boolean wildcard = hideModes.contains(IEditModeConfig.HideMode.WILDCARD);
            boolean single = hideModes.contains(IEditModeConfig.HideMode.SINGLE);
            if (wildcard && single) {
                GuiComponent.fill((PoseStack)poseStack, (int)(area.getX() + padding), (int)(area.getY() + padding), (int)(area.getX() + 16 + padding), (int)(area.getY() + 8 + padding), (int)-570448640);
                GuiComponent.fill((PoseStack)poseStack, (int)(area.getX() + padding), (int)(area.getY() + 8 + padding), (int)(area.getX() + 16 + padding), (int)(area.getY() + 16 + padding), (int)-570490880);
            } else if (wildcard) {
                GuiComponent.fill((PoseStack)poseStack, (int)(area.getX() + padding), (int)(area.getY() + padding), (int)(area.getX() + 16 + padding), (int)(area.getY() + 16 + padding), (int)-570448640);
            } else if (single) {
                GuiComponent.fill((PoseStack)poseStack, (int)(area.getX() + padding), (int)(area.getY() + padding), (int)(area.getX() + 16 + padding), (int)(area.getY() + 16 + padding), (int)-570490880);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

