/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.helpers.IColorHelper;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.Internal;
import mezz.jei.common.config.IIngredientFilterConfig;
import mezz.jei.common.gui.JeiTooltip;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.common.util.IngredientTooltipHelper;
import mezz.jei.common.util.SafeIngredientUtil;
import mezz.jei.core.config.IWorldConfig;
import mezz.jei.core.search.SearchMode;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public final class IngredientGridTooltipHelper {
    private final IIngredientManager ingredientManager;
    private final IIngredientFilterConfig ingredientFilterConfig;
    private final IWorldConfig worldConfig;
    private final IInternalKeyMappings keyBindings;
    private final IColorHelper colorHelper;

    public IngredientGridTooltipHelper(IIngredientManager ingredientManager, IIngredientFilterConfig ingredientFilterConfig, IWorldConfig worldConfig, IInternalKeyMappings keyBindings, IColorHelper colorHelper) {
        this.ingredientManager = ingredientManager;
        this.ingredientFilterConfig = ingredientFilterConfig;
        this.worldConfig = worldConfig;
        this.keyBindings = keyBindings;
        this.colorHelper = colorHelper;
    }

    public <T> void drawTooltip(PoseStack poseStack, int mouseX, int mouseY, ITypedIngredient<T> typedIngredient) {
        IIngredientType ingredientType = typedIngredient.getType();
        IIngredientRenderer ingredientRenderer = this.ingredientManager.getIngredientRenderer(ingredientType);
        IIngredientHelper ingredientHelper = this.ingredientManager.getIngredientHelper(ingredientType);
        JeiTooltip tooltip = new JeiTooltip();
        this.getTooltip(tooltip, typedIngredient, ingredientRenderer, ingredientHelper);
        tooltip.draw(poseStack, mouseX, mouseY);
    }

    public <T> void getTooltip(JeiTooltip tooltip, ITypedIngredient<T> typedIngredient, IIngredientRenderer<T> ingredientRenderer, IIngredientHelper<T> ingredientHelper) {
        Object ingredient = typedIngredient.getIngredient();
        IngredientTooltipHelper.getIngredientTooltipSafe((ITooltipBuilder)tooltip, (Object)ingredient, ingredientRenderer);
        IModIdHelper modIdHelper = Internal.getJeiRuntime().getJeiHelpers().getModIdHelper();
        modIdHelper.getModNameForTooltip(typedIngredient).ifPresent(arg_0 -> ((JeiTooltip)tooltip).add(arg_0));
        if (this.ingredientFilterConfig.getColorSearchMode() != SearchMode.DISABLED) {
            this.addColorSearchInfoToTooltip(tooltip, ingredient, ingredientHelper);
        }
        if (this.worldConfig.isEditModeEnabled()) {
            IngredientGridTooltipHelper.addEditModeInfoToTooltip(tooltip, this.keyBindings);
        }
    }

    private <T> void addColorSearchInfoToTooltip(JeiTooltip tooltip, T ingredient, IIngredientHelper<T> ingredientHelper) {
        Iterable colors = ingredientHelper.getColors(ingredient);
        String colorNamesString = StreamSupport.stream(colors.spliterator(), false).map(arg_0 -> ((IColorHelper)this.colorHelper).getClosestColorName(arg_0)).collect(Collectors.joining(", "));
        if (!colorNamesString.isEmpty()) {
            MutableComponent colorTranslation = Component.translatable((String)"jei.tooltip.item.colors", (Object[])new Object[]{colorNamesString}).withStyle(ChatFormatting.GRAY);
            tooltip.add((Component)colorTranslation);
        }
    }

    private static void addEditModeInfoToTooltip(JeiTooltip tooltip, IInternalKeyMappings keyBindings) {
        List<MutableComponent> lines = List.of(CommonComponents.EMPTY, Component.translatable((String)"gui.jei.editMode.description").withStyle(ChatFormatting.DARK_GREEN), Component.translatable((String)"gui.jei.editMode.description.hide", (Object[])new Object[]{keyBindings.getToggleHideIngredient().getTranslatedKeyMessage()}).withStyle(ChatFormatting.GRAY), Component.translatable((String)"gui.jei.editMode.description.hide.wild", (Object[])new Object[]{keyBindings.getToggleWildcardHideIngredient().getTranslatedKeyMessage()}).withStyle(ChatFormatting.GRAY));
        tooltip.addAll(lines);
    }

    public <T> void getIngredientTooltip(JeiTooltip tooltip, ITypedIngredient<T> typedIngredient, IIngredientRenderer<T> ingredientRenderer, IIngredientHelper<T> ingredientHelper) {
        SafeIngredientUtil.getTooltip((ITooltipBuilder)tooltip, (IIngredientManager)this.ingredientManager, ingredientRenderer, typedIngredient);
        if (this.ingredientFilterConfig.getColorSearchMode() != SearchMode.DISABLED) {
            this.addColorSearchInfoToTooltip(tooltip, typedIngredient.getIngredient(), ingredientHelper);
        }
        if (this.worldConfig.isEditModeEnabled()) {
            IngredientGridTooltipHelper.addEditModeInfoToTooltip(tooltip, this.keyBindings);
        }
    }
}

