/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay;

import java.util.Optional;
import java.util.function.BooleanSupplier;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.JeiTooltip;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.common.network.IConnectionToServer;
import mezz.jei.common.network.packets.PacketJei;
import mezz.jei.common.network.packets.PacketRequestCheatPermission;
import mezz.jei.common.platform.IPlatformConfigHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.core.config.IWorldConfig;
import mezz.jei.gui.elements.GuiIconToggleButton;
import mezz.jei.gui.input.UserInput;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;

public class ConfigButton
extends GuiIconToggleButton {
    private final IInternalKeyMappings keyBindings;
    private final BooleanSupplier isListDisplayed;
    private final IWorldConfig worldConfig;

    public static ConfigButton create(BooleanSupplier isListDisplayed, IWorldConfig worldConfig, IInternalKeyMappings keyBindings) {
        Textures textures = Internal.getTextures();
        return new ConfigButton((IDrawable)textures.getConfigButtonIcon(), (IDrawable)textures.getConfigButtonCheatIcon(), isListDisplayed, worldConfig, keyBindings);
    }

    private ConfigButton(IDrawable disabledIcon, IDrawable enabledIcon, BooleanSupplier isListDisplayed, IWorldConfig worldConfig, IInternalKeyMappings keyBindings) {
        super(disabledIcon, enabledIcon);
        this.isListDisplayed = isListDisplayed;
        this.worldConfig = worldConfig;
        this.keyBindings = keyBindings;
    }

    @Override
    protected void getTooltips(JeiTooltip tooltip) {
        tooltip.add((Component)Component.translatable((String)"jei.tooltip.config"));
        if (!this.worldConfig.isOverlayEnabled()) {
            tooltip.add((Component)Component.translatable((String)"jei.tooltip.ingredient.list.disabled").withStyle(ChatFormatting.GOLD));
            tooltip.addKeyUsageComponent("jei.tooltip.ingredient.list.disabled.how.to.fix", this.keyBindings.getToggleOverlay());
        } else if (!this.isListDisplayed.getAsBoolean()) {
            tooltip.add((Component)Component.translatable((String)"jei.tooltip.not.enough.space").withStyle(ChatFormatting.GOLD));
        }
        if (this.worldConfig.isCheatItemsEnabled()) {
            tooltip.add((Component)Component.translatable((String)"jei.tooltip.cheat.mode.button.enabled").withStyle(ChatFormatting.RED));
            if (!this.keyBindings.getToggleCheatMode().isUnbound()) {
                tooltip.addKeyUsageComponent("jei.tooltip.cheat.mode.how.to.disable.hotkey", this.keyBindings.getToggleCheatMode());
            } else if (!this.keyBindings.getToggleCheatModeConfigButton().isUnbound()) {
                tooltip.addKeyUsageComponent("jei.tooltip.cheat.mode.how.to.disable.hover.config.button.hotkey", this.keyBindings.getToggleCheatModeConfigButton());
            }
        }
    }

    @Override
    protected boolean isIconToggledOn() {
        return this.worldConfig.isCheatItemsEnabled();
    }

    @Override
    protected boolean onMouseClicked(UserInput input) {
        if (this.worldConfig.isOverlayEnabled()) {
            if (!input.isSimulate()) {
                if (input.is(this.keyBindings.getToggleCheatModeConfigButton())) {
                    this.worldConfig.toggleCheatItemsEnabled();
                    if (this.worldConfig.isCheatItemsEnabled()) {
                        IConnectionToServer serverConnection = Internal.getServerConnection();
                        serverConnection.sendPacketToServer((PacketJei)new PacketRequestCheatPermission());
                    }
                } else {
                    ConfigButton.openSettings();
                }
            }
            return true;
        }
        return false;
    }

    private static void openSettings() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        IPlatformConfigHelper configHelper = Services.PLATFORM.getConfigHelper();
        Optional configScreen = configHelper.getConfigScreen();
        if (configScreen.isPresent()) {
            mc.setScreen((Screen)configScreen.get());
        } else {
            Component message = ConfigButton.getMissingConfigScreenMessage(configHelper);
            mc.player.displayClientMessage(message, false);
        }
    }

    private static Component getMissingConfigScreenMessage(IPlatformConfigHelper configHelper) {
        return Component.translatable((String)"jei.message.configured").setStyle(Style.EMPTY.withColor(ChatFormatting.DARK_BLUE).withUnderlined(Boolean.valueOf(true)).withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.curseforge.com/minecraft/mc-mods/configured"))).append("\n").append((Component)Component.translatable((String)"jei.message.config.folder").setStyle(Style.EMPTY.withColor(ChatFormatting.WHITE).withUnderlined(Boolean.valueOf(true)).withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_FILE, configHelper.createJeiConfigDir().toAbsolutePath().toString()))));
    }
}

