/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.handlers.IGuiProperties;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferManager;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IRecipesGui;
import mezz.jei.common.gui.TooltipRenderer;
import mezz.jei.common.gui.elements.DrawableNineSliceTexture;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.input.ClickableIngredientInternal;
import mezz.jei.common.input.IClickableIngredientInternal;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.MathUtil;
import mezz.jei.common.util.StringUtil;
import mezz.jei.gui.GuiProperties;
import mezz.jei.gui.config.IClientConfig;
import mezz.jei.gui.elements.GuiIconButtonSmall;
import mezz.jei.gui.input.IRecipeFocusSource;
import mezz.jei.gui.input.IUserInputHandler;
import mezz.jei.gui.input.InputType;
import mezz.jei.gui.input.MouseUtil;
import mezz.jei.gui.input.UserInput;
import mezz.jei.gui.recipes.IRecipeGuiLogic;
import mezz.jei.gui.recipes.IRecipeLogicStateListener;
import mezz.jei.gui.recipes.RecipeCatalysts;
import mezz.jei.gui.recipes.RecipeGuiLogic;
import mezz.jei.gui.recipes.RecipeGuiTabs;
import mezz.jei.gui.recipes.RecipeTransferButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.Nullable;

public class RecipesGui
extends Screen
implements IRecipesGui,
IRecipeFocusSource,
IRecipeLogicStateListener {
    private static final int borderPadding = 6;
    private static final int innerPadding = 14;
    private static final int buttonWidth = 13;
    private static final int buttonHeight = 13;
    private final IRecipeTransferManager recipeTransferManager;
    private final IModIdHelper modIdHelper;
    private final IClientConfig clientConfig;
    private final IInternalKeyMappings keyBindings;
    private final Textures textures;
    private final IFocusFactory focusFactory;
    private final IIngredientManager ingredientManager;
    private int headerHeight;
    private final IRecipeGuiLogic logic;
    private final List<IRecipeLayoutDrawable<?>> recipeLayouts = new ArrayList();
    private String pageString = "1/1";
    private Component title = CommonComponents.f_237098_;
    private final DrawableNineSliceTexture background;
    private final RecipeCatalysts recipeCatalysts;
    private final RecipeGuiTabs recipeGuiTabs;
    private final List<RecipeTransferButton> recipeTransferButtons;
    private final GuiIconButtonSmall nextRecipeCategory;
    private final GuiIconButtonSmall previousRecipeCategory;
    private final GuiIconButtonSmall nextPage;
    private final GuiIconButtonSmall previousPage;
    @Nullable
    private Screen parentScreen;
    private ImmutableRect2i area = ImmutableRect2i.EMPTY;
    private ImmutableRect2i titleArea = ImmutableRect2i.EMPTY;
    private ImmutableRect2i titleStringArea = ImmutableRect2i.EMPTY;
    private boolean init = false;

    public RecipesGui(IRecipeManager recipeManager, IRecipeTransferManager recipeTransferManager, IIngredientManager ingredientManager, IModIdHelper modIdHelper, IClientConfig clientConfig, Textures textures, IInternalKeyMappings keyBindings, IFocusFactory focusFactory) {
        super((Component)Component.m_237113_((String)"Recipes"));
        this.textures = textures;
        this.recipeTransferButtons = new ArrayList<RecipeTransferButton>();
        this.recipeTransferManager = recipeTransferManager;
        this.ingredientManager = ingredientManager;
        this.modIdHelper = modIdHelper;
        this.clientConfig = clientConfig;
        this.keyBindings = keyBindings;
        this.logic = new RecipeGuiLogic(recipeManager, recipeTransferManager, this, focusFactory);
        this.recipeCatalysts = new RecipeCatalysts(textures, recipeManager);
        this.recipeGuiTabs = new RecipeGuiTabs(this.logic, textures, ingredientManager);
        this.focusFactory = focusFactory;
        this.f_96541_ = Minecraft.m_91087_();
        IDrawableStatic arrowNext = textures.getArrowNext();
        IDrawableStatic arrowPrevious = textures.getArrowPrevious();
        this.nextRecipeCategory = new GuiIconButtonSmall(0, 0, 13, 13, arrowNext, b -> this.logic.nextRecipeCategory(), textures);
        this.previousRecipeCategory = new GuiIconButtonSmall(0, 0, 13, 13, arrowPrevious, b -> this.logic.previousRecipeCategory(), textures);
        this.nextPage = new GuiIconButtonSmall(0, 0, 13, 13, arrowNext, b -> this.logic.nextPage(), textures);
        this.previousPage = new GuiIconButtonSmall(0, 0, 13, 13, arrowPrevious, b -> this.logic.previousPage(), textures);
        this.background = textures.getRecipeGuiBackground();
    }

    private static void drawCenteredStringWithShadow(PoseStack poseStack, Font font, String string, ImmutableRect2i area) {
        ImmutableRect2i textArea = MathUtil.centerTextArea(area, font, string);
        font.m_92750_(poseStack, string, (float)textArea.getX(), (float)textArea.getY(), -1);
    }

    private static void drawCenteredStringWithShadow(PoseStack poseStack, Font font, Component text, ImmutableRect2i area) {
        ImmutableRect2i textArea = MathUtil.centerTextArea(area, font, (FormattedText)text);
        font.m_92763_(poseStack, text, (float)textArea.getX(), (float)textArea.getY(), -1);
    }

    public ImmutableRect2i getArea() {
        return this.area;
    }

    public int getRecipeCatalystExtraWidth() {
        if (this.recipeCatalysts.isEmpty()) {
            return 0;
        }
        return this.recipeCatalysts.getWidth();
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7856_() {
        super.m_7856_();
        int xSize = 198;
        int ySize = this.clientConfig.isCenterSearchBarEnabled() ? this.f_96544_ - 76 : this.f_96544_ - 68;
        int extraSpace = 0;
        int maxHeight = this.clientConfig.getMaxRecipeGuiHeight();
        if (ySize > maxHeight) {
            extraSpace = ySize - maxHeight;
            ySize = maxHeight;
        }
        int guiLeft = (this.f_96543_ - 198) / 2;
        int guiTop = 45 + extraSpace / 2;
        this.area = new ImmutableRect2i(guiLeft, guiTop, 198, ySize);
        int rightButtonX = guiLeft + 198 - 6 - 13;
        int leftButtonX = guiLeft + 6;
        Objects.requireNonNull(this.f_96547_);
        int titleHeight = 9 + 6;
        int recipeClassButtonTop = guiTop + titleHeight - 13 + 2;
        this.nextRecipeCategory.f_93620_ = rightButtonX;
        this.nextRecipeCategory.f_93621_ = recipeClassButtonTop;
        this.previousRecipeCategory.f_93620_ = leftButtonX;
        this.previousRecipeCategory.f_93621_ = recipeClassButtonTop;
        int pageButtonTop = recipeClassButtonTop + 13 + 2;
        this.nextPage.f_93620_ = rightButtonX;
        this.nextPage.f_93621_ = pageButtonTop;
        this.previousPage.f_93620_ = leftButtonX;
        this.previousPage.f_93621_ = pageButtonTop;
        this.headerHeight = pageButtonTop + 13 - guiTop;
        this.titleArea = MathUtil.union(this.previousRecipeCategory.getArea(), this.nextRecipeCategory.getArea()).cropLeft(this.previousRecipeCategory.m_5711_() + 14).cropRight(this.nextRecipeCategory.m_5711_() + 14);
        this.m_142416_((GuiEventListener)this.nextRecipeCategory);
        this.m_142416_((GuiEventListener)this.previousRecipeCategory);
        this.m_142416_((GuiEventListener)this.nextPage);
        this.m_142416_((GuiEventListener)this.previousPage);
        this.init = true;
        this.updateLayout();
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        if (this.f_96541_ == null) {
            return;
        }
        this.m_7333_(poseStack);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = this.area.getX();
        int y = this.area.getY();
        int width = this.area.getWidth();
        int height = this.area.getHeight();
        this.background.draw(poseStack, x, y, width, height);
        RenderSystem.m_69461_();
        RecipesGui.m_93172_((PoseStack)poseStack, (int)(x + 6 + 13), (int)this.nextRecipeCategory.f_93621_, (int)(x + width - 6 - 13), (int)(this.nextRecipeCategory.f_93621_ + 13), (int)0x30000000);
        RecipesGui.m_93172_((PoseStack)poseStack, (int)(x + 6 + 13), (int)this.nextPage.f_93621_, (int)(x + width - 6 - 13), (int)(this.nextPage.f_93621_ + 13), (int)0x30000000);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RecipesGui.drawCenteredStringWithShadow(poseStack, this.f_96547_, this.title, this.titleArea);
        ImmutableRect2i pageArea = MathUtil.union(this.previousPage.getArea(), this.nextPage.getArea());
        RecipesGui.drawCenteredStringWithShadow(poseStack, this.f_96547_, this.pageString, pageArea);
        this.nextRecipeCategory.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        this.previousRecipeCategory.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        this.nextPage.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        this.previousPage.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        Optional<IRecipeLayoutDrawable<?>> hoveredRecipeLayout = this.drawLayouts(poseStack, mouseX, mouseY);
        Optional<IRecipeSlotDrawable> hoveredRecipeCatalyst = this.recipeCatalysts.draw(poseStack, mouseX, mouseY);
        this.recipeGuiTabs.draw(this.f_96541_, poseStack, mouseX, mouseY, this.modIdHelper);
        for (RecipeTransferButton button : this.recipeTransferButtons) {
            button.drawToolTip(poseStack, mouseX, mouseY);
        }
        RenderSystem.m_69461_();
        hoveredRecipeLayout.ifPresent(l -> l.drawOverlays(poseStack, mouseX, mouseY));
        hoveredRecipeCatalyst.ifPresent(h -> h.drawHoverOverlays(poseStack));
        hoveredRecipeCatalyst.ifPresent(h -> h.getDisplayedIngredient().ifPresent(i -> {
            List<Component> tooltip = h.getTooltip();
            tooltip = this.modIdHelper.addModNameToIngredientTooltip(tooltip, i);
            TooltipRenderer.drawHoveringText(poseStack, tooltip, mouseX, mouseY, i, this.ingredientManager);
        }));
        RenderSystem.m_69482_();
        if (this.titleStringArea.contains(mouseX, mouseY) && !this.logic.hasAllCategories()) {
            MutableComponent showAllRecipesString = Component.m_237115_((String)"jei.tooltip.show.all.recipes");
            TooltipRenderer.drawHoveringText(poseStack, List.of(showAllRecipesString), mouseX, mouseY);
        }
    }

    private Optional<IRecipeLayoutDrawable<?>> drawLayouts(PoseStack poseStack, int mouseX, int mouseY) {
        IRecipeLayoutDrawable<?> hoveredLayout = null;
        for (IRecipeLayoutDrawable<?> recipeLayout : this.recipeLayouts) {
            if (recipeLayout.isMouseOver(mouseX, mouseY)) {
                hoveredLayout = recipeLayout;
            }
            recipeLayout.drawRecipe(poseStack, mouseX, mouseY);
        }
        Minecraft minecraft = Minecraft.m_91087_();
        float partialTicks = minecraft.m_91296_();
        for (RecipeTransferButton button : this.recipeTransferButtons) {
            button.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        }
        RenderSystem.m_69461_();
        return Optional.ofNullable(hoveredLayout);
    }

    public void m_86600_() {
        super.m_86600_();
        Optional.ofNullable(this.f_96541_).map(minecraft -> minecraft.f_91074_).ifPresent(localPlayer -> {
            AbstractContainerMenu container = this.getParentContainer().orElse(null);
            List<RecipeTransferButton> transferButtons = this.recipeTransferButtons;
            for (int i = 0; i < transferButtons.size(); ++i) {
                IRecipeLayoutDrawable<?> recipeLayout = this.recipeLayouts.get(i);
                RecipeTransferButton button = transferButtons.get(i);
                Rect2i buttonArea = recipeLayout.getRecipeTransferButtonArea();
                button.update(buttonArea, this.recipeTransferManager, container, (Player)localPlayer);
            }
        });
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        if (this.f_96541_ != null && this.f_96541_.f_91080_ == this) {
            if (this.area.contains(mouseX, mouseY)) {
                return true;
            }
            for (IRecipeLayoutDrawable<?> recipeLayout : this.recipeLayouts) {
                if (!recipeLayout.isMouseOver(mouseX, mouseY)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Stream<IClickableIngredientInternal<?>> getIngredientUnderMouse(double mouseX, double mouseY) {
        if (this.isOpen()) {
            return Stream.concat(this.recipeCatalysts.getIngredientUnderMouse(mouseX, mouseY), this.getRecipeLayoutsIngredientUnderMouse(mouseX, mouseY));
        }
        return Stream.empty();
    }

    private Stream<IClickableIngredientInternal<?>> getRecipeLayoutsIngredientUnderMouse(double mouseX, double mouseY) {
        return this.recipeLayouts.stream().map(recipeLayout -> RecipesGui.getRecipeLayoutIngredientUnderMouse(recipeLayout, mouseX, mouseY)).flatMap(Optional::stream);
    }

    private static Optional<IClickableIngredientInternal<?>> getRecipeLayoutIngredientUnderMouse(IRecipeLayoutDrawable<?> recipeLayout, double mouseX, double mouseY) {
        return recipeLayout.getRecipeSlotUnderMouse(mouseX, mouseY).flatMap(recipeSlot -> RecipesGui.getClickedIngredient(recipeLayout, recipeSlot));
    }

    private static Optional<IClickableIngredientInternal<?>> getClickedIngredient(IRecipeLayoutDrawable<?> recipeLayout, IRecipeSlotDrawable recipeSlot) {
        return recipeSlot.getDisplayedIngredient().map(displayedIngredient -> {
            ImmutableRect2i area = RecipesGui.absoluteClickedArea(recipeLayout, recipeSlot.getRect());
            return new ClickableIngredientInternal(displayedIngredient, area, false, true);
        });
    }

    private static ImmutableRect2i absoluteClickedArea(IRecipeLayoutDrawable<?> recipeLayout, Rect2i area) {
        Rect2i layoutArea = recipeLayout.getRect();
        return new ImmutableRect2i(area.m_110085_() + layoutArea.m_110085_(), area.m_110086_() + layoutArea.m_110086_(), area.m_110090_(), area.hashCode());
    }

    public boolean m_6050_(double scrollX, double scrollY, double scrollDelta) {
        double y;
        double x = MouseUtil.getX();
        if (this.m_5953_(x, y = MouseUtil.getY())) {
            if (scrollDelta < 0.0) {
                this.logic.nextPage();
                return true;
            }
            if (scrollDelta > 0.0) {
                this.logic.previousPage();
                return true;
            }
        }
        return super.m_6050_(scrollX, scrollY, scrollDelta);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        boolean handled = UserInput.fromVanilla(mouseX, mouseY, mouseButton, InputType.IMMEDIATE).map(this::handleInput).orElse(false);
        if (handled) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        UserInput input = UserInput.fromVanilla(keyCode, scanCode, modifiers, InputType.IMMEDIATE);
        return this.handleInput(input);
    }

    private boolean handleInput(UserInput input) {
        IUserInputHandler handler;
        double mouseY;
        double mouseX = input.getMouseX();
        if (this.m_5953_(mouseX, mouseY = input.getMouseY())) {
            if (this.titleStringArea.contains(mouseX, mouseY)) {
                if (input.is(this.keyBindings.getLeftClick()) && this.logic.setCategoryFocus()) {
                    return true;
                }
            } else {
                for (IRecipeLayoutDrawable<?> recipeLayout : this.recipeLayouts) {
                    if (!this.handleRecipeLayoutInput(recipeLayout, input)) continue;
                    return true;
                }
            }
        }
        if ((handler = this.recipeGuiTabs.getInputHandler()).handleUserInput(this, input, this.keyBindings).isPresent()) {
            return true;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (input.is(this.keyBindings.getCloseRecipeGui()) || input.is(minecraft.f_91066_.f_92092_)) {
            this.m_7379_();
            return true;
        }
        if (input.is(this.keyBindings.getRecipeBack())) {
            this.back();
            return true;
        }
        if (input.is(this.keyBindings.getNextCategory())) {
            this.logic.nextRecipeCategory();
            return true;
        }
        if (input.is(this.keyBindings.getPreviousCategory())) {
            this.logic.previousRecipeCategory();
            return true;
        }
        if (input.is(this.keyBindings.getNextRecipePage())) {
            this.logic.nextPage();
            return true;
        }
        if (input.is(this.keyBindings.getPreviousRecipePage())) {
            this.logic.previousPage();
            return true;
        }
        return false;
    }

    private <R> boolean handleRecipeLayoutInput(IRecipeLayoutDrawable<R> recipeLayout, UserInput input) {
        if (!recipeLayout.isMouseOver(input.getMouseX(), input.getMouseY())) {
            return false;
        }
        Rect2i recipeArea = recipeLayout.getRect();
        double recipeMouseX = input.getMouseX() - (double)recipeArea.m_110085_();
        double recipeMouseY = input.getMouseY() - (double)recipeArea.m_110086_();
        R recipe = recipeLayout.getRecipe();
        IRecipeCategory<R> recipeCategory = recipeLayout.getRecipeCategory();
        if (recipeCategory.handleInput(recipe, recipeMouseX, recipeMouseY, input.getKey())) {
            return true;
        }
        if (input.is(this.keyBindings.getCopyRecipeId())) {
            return this.handleCopyRecipeId(recipeLayout);
        }
        return false;
    }

    private <R> boolean handleCopyRecipeId(IRecipeLayoutDrawable<R> recipeLayout) {
        R recipe;
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        IRecipeCategory<R> recipeCategory = recipeLayout.getRecipeCategory();
        ResourceLocation registryName = recipeCategory.getRegistryName(recipe = recipeLayout.getRecipe());
        if (registryName == null) {
            MutableComponent message = Component.m_237115_((String)"jei.message.copy.recipe.id.failure");
            if (player != null) {
                player.m_5661_((Component)message, false);
            }
            return false;
        }
        String recipeId = registryName.toString();
        minecraft.f_91068_.m_90911_(recipeId);
        MutableComponent message = Component.m_237110_((String)"jei.message.copy.recipe.id.success", (Object[])new Object[]{recipeId});
        if (player != null) {
            player.m_5661_((Component)message, false);
        }
        return true;
    }

    public boolean isOpen() {
        return this.f_96541_ != null && this.f_96541_.f_91080_ == this;
    }

    private void open() {
        if (this.f_96541_ != null) {
            if (!this.isOpen()) {
                this.parentScreen = this.f_96541_.f_91080_;
            }
            this.f_96541_.m_91152_((Screen)this);
        }
    }

    public void m_7379_() {
        if (this.isOpen() && this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.parentScreen);
            this.parentScreen = null;
            this.logic.clearHistory();
            return;
        }
        super.m_7379_();
    }

    @Override
    public void show(List<IFocus<?>> focuses) {
        IFocusGroup checkedFocuses = this.focusFactory.createFocusGroup(focuses);
        if (this.logic.setFocus(checkedFocuses)) {
            this.open();
        }
    }

    @Override
    public void showTypes(List<RecipeType<?>> recipeTypes) {
        ErrorUtil.checkNotEmpty(recipeTypes, "recipeTypes");
        if (this.logic.setCategoryFocus(recipeTypes)) {
            this.open();
        }
    }

    @Override
    public <T> Optional<T> getIngredientUnderMouse(IIngredientType<T> ingredientType) {
        double x = MouseUtil.getX();
        double y = MouseUtil.getY();
        return this.getIngredientUnderMouse(x, y).map(IClickableIngredientInternal::getTypedIngredient).flatMap(i -> i.getIngredient(ingredientType).stream()).findFirst();
    }

    public void back() {
        this.logic.back();
    }

    private void updateLayout() {
        int heightPerRecipe;
        if (!this.init) {
            return;
        }
        IRecipeCategory<?> recipeCategory = this.logic.getSelectedRecipeCategory();
        int x = this.area.getX();
        int y = this.area.getY();
        int width = this.area.getWidth();
        int height = this.area.getHeight();
        int availableHeight = height - this.headerHeight;
        int recipesPerPage = availableHeight / (heightPerRecipe = recipeCategory.getHeight() + 14);
        if (recipesPerPage == 0) {
            availableHeight = heightPerRecipe;
            recipesPerPage = 1;
        }
        this.logic.setRecipesPerPage(recipesPerPage);
        this.title = StringUtil.stripStyling(recipeCategory.getTitle());
        int availableTitleWidth = this.titleArea.getWidth();
        if (this.f_96547_.m_92852_((FormattedText)this.title) > availableTitleWidth) {
            this.title = StringUtil.truncateStringToWidth(this.title, availableTitleWidth, this.f_96547_);
        }
        this.titleStringArea = MathUtil.centerTextArea(this.titleArea, this.f_96547_, (FormattedText)this.title);
        this.recipeLayouts.clear();
        int recipeXOffset = x + (width - recipeCategory.getWidth()) / 2;
        int recipeSpacing = (availableHeight - recipesPerPage * recipeCategory.getHeight()) / (recipesPerPage + 1);
        int spacingY = recipeCategory.getHeight() + recipeSpacing;
        int recipeYOffset = y + this.headerHeight + recipeSpacing;
        for (IRecipeLayoutDrawable<?> recipeLayout : this.logic.getRecipeLayouts()) {
            recipeLayout.setPosition(recipeXOffset, recipeYOffset);
            recipeYOffset += spacingY;
            this.recipeLayouts.add(recipeLayout);
        }
        this.addRecipeTransferButtons(this.recipeLayouts);
        this.nextPage.f_93623_ = this.previousPage.f_93623_ = this.logic.hasMultiplePages();
        this.nextRecipeCategory.f_93623_ = this.previousRecipeCategory.f_93623_ = this.logic.hasMultipleCategories();
        this.pageString = this.logic.getPageString();
        List<ITypedIngredient<?>> recipeCatalystIngredients = this.logic.getRecipeCatalysts().toList();
        this.recipeCatalysts.updateLayout(recipeCatalystIngredients, this.area);
        this.recipeGuiTabs.initLayout(this.area);
    }

    private void addRecipeTransferButtons(List<IRecipeLayoutDrawable<?>> recipeLayouts) {
        if (this.f_96541_ == null) {
            return;
        }
        LocalPlayer player = this.f_96541_.f_91074_;
        if (player == null) {
            return;
        }
        for (GuiEventListener guiEventListener : this.recipeTransferButtons) {
            this.m_169411_(guiEventListener);
        }
        this.recipeTransferButtons.clear();
        AbstractContainerMenu container = this.getParentContainer().orElse(null);
        recipeLayouts.forEach(arg_0 -> this.lambda$addRecipeTransferButtons$14(container, (Player)player, arg_0));
    }

    private Optional<AbstractContainerMenu> getParentContainer() {
        Screen screen = this.parentScreen;
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
            AbstractContainerMenu menu = screen2.m_6262_();
            return Optional.of(menu);
        }
        return Optional.empty();
    }

    @Override
    public void onStateChange() {
        this.updateLayout();
    }

    @Nullable
    public IGuiProperties getProperties() {
        if (this.f_96543_ <= 0 || this.f_96544_ <= 0) {
            return null;
        }
        int extraWidth = this.getRecipeCatalystExtraWidth();
        ImmutableRect2i recipeArea = this.getArea();
        int guiXSize = recipeArea.getWidth() + extraWidth;
        int guiYSize = recipeArea.getHeight();
        if (guiXSize <= 0 || guiYSize <= 0) {
            return null;
        }
        return new GuiProperties(this.getClass(), recipeArea.getX() - extraWidth, recipeArea.getY(), guiXSize, guiYSize, this.f_96543_, this.f_96544_);
    }

    private /* synthetic */ void lambda$addRecipeTransferButtons$14(AbstractContainerMenu container, Player player, IRecipeLayoutDrawable recipeLayout) {
        Rect2i buttonArea = recipeLayout.getRecipeTransferButtonArea();
        IDrawableStatic icon = this.textures.getRecipeTransfer();
        RecipeTransferButton button = new RecipeTransferButton(icon, recipeLayout, this.textures, this::m_7379_);
        button.update(buttonArea, this.recipeTransferManager, container, player);
        this.m_142416_((GuiEventListener)button);
        this.recipeTransferButtons.add(button);
    }
}

