/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.util;

import java.nio.file.Path;
import java.util.Optional;
import mezz.jei.core.util.PathUtil;
import mezz.jei.core.util.ReflectionUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.network.Connection;
import net.minecraft.world.level.storage.LevelStorageSource;

public final class ServerConfigPathUtil {
    private static final Path worldDirPath = Path.of("world", new String[0]);
    private static final ReflectionUtil reflectionUtil = new ReflectionUtil();

    private ServerConfigPathUtil() {
    }

    public static Optional<Path> getWorldPath(Path basePath) {
        return ServerConfigPathUtil.getWorldPath().map(basePath::resolve);
    }

    private static Optional<Path> getWorldPath() {
        Minecraft minecraft = Minecraft.m_91087_();
        return Optional.ofNullable(minecraft.m_91403_()).flatMap(clientPacketListener -> {
            Connection connection = clientPacketListener.m_6198_();
            if (connection.m_129531_()) {
                return Optional.ofNullable(minecraft.m_91092_()).flatMap(minecraftServer -> reflectionUtil.getFieldWithClass(minecraftServer, LevelStorageSource.LevelStorageAccess.class).findFirst().map(LevelStorageSource.LevelStorageAccess::m_78277_).map(PathUtil::sanitizePathName).map(name -> worldDirPath.resolve("local").resolve((String)name)));
            }
            return Optional.ofNullable(minecraft.m_91089_()).map(serverData -> {
                int ipHash = serverData.f_105363_.hashCode();
                String ipHashHex = Integer.toHexString(ipHash);
                String name = String.format("%s_%s", serverData.f_105362_, ipHashHex);
                name = PathUtil.sanitizePathName(name);
                return worldDirPath.resolve("server").resolve(name);
            });
        });
    }
}

