/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.input;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Optional;
import mezz.jei.common.gui.elements.DrawableNineSliceTexture;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.platform.IPlatformInputHelper;
import mezz.jei.common.platform.IPlatformScreenHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.core.util.TextHistory;
import mezz.jei.gui.input.IUserInputHandler;
import mezz.jei.gui.input.handlers.TextFieldInputHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import org.jetbrains.annotations.Nullable;

public class GuiTextFieldFilter
extends EditBox {
    private static final int maxSearchLength = 128;
    private static final TextHistory history = new TextHistory();
    private ImmutableRect2i area;
    private final DrawableNineSliceTexture background;
    private ImmutableRect2i backgroundBounds;
    private boolean previousKeyboardRepeatEnabled;
    @Nullable
    private AbstractWidget previouslyFocusedWidget;

    public GuiTextFieldFilter(Textures textures) {
        super(Minecraft.m_91087_().f_91062_, 0, 0, 0, 0, CommonComponents.f_237098_);
        this.m_94199_(128);
        this.area = ImmutableRect2i.EMPTY;
        this.background = textures.getSearchBackground();
        this.backgroundBounds = ImmutableRect2i.EMPTY;
        this.m_94182_(false);
    }

    public void updateBounds(ImmutableRect2i area) {
        this.backgroundBounds = area;
        this.f_93620_ = area.getX() + 4;
        this.f_93621_ = area.getY() + (area.getHeight() - 8) / 2;
        this.f_93618_ = area.getWidth() - 12;
        this.f_93619_ = area.getHeight();
        this.area = area;
    }

    public void m_94144_(String filterText) {
        if (!filterText.equals(this.m_94155_())) {
            super.m_94144_(filterText);
        }
    }

    public Optional<String> getHistory(TextHistory.Direction direction) {
        String currentText = this.m_94155_();
        return history.get(direction, currentText);
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return this.area.contains(mouseX, mouseY);
    }

    public IUserInputHandler createInputHandler() {
        return new TextFieldInputHandler(this);
    }

    public void m_93692_(boolean keyboardFocus) {
        boolean previousFocus = this.m_93696_();
        super.m_93692_(keyboardFocus);
        if (previousFocus != keyboardFocus) {
            Minecraft minecraft = Minecraft.m_91087_();
            if (keyboardFocus) {
                IPlatformInputHelper inputHelper = Services.PLATFORM.getInputHelper();
                this.previousKeyboardRepeatEnabled = inputHelper.isSendRepeatsToGui(minecraft.f_91068_);
                minecraft.f_91068_.m_90926_(true);
                Screen screen = minecraft.f_91080_;
                if (screen != null) {
                    GuiEventListener guiEventListener = screen.m_7222_();
                    if (guiEventListener instanceof AbstractWidget) {
                        AbstractWidget widget = (AbstractWidget)guiEventListener;
                        IPlatformScreenHelper screenHelper = Services.PLATFORM.getScreenHelper();
                        screenHelper.setFocused(widget, false);
                        this.previouslyFocusedWidget = widget;
                    }
                    screen.m_7522_(null);
                }
            } else {
                if (this.previouslyFocusedWidget != null) {
                    Screen screen = minecraft.f_91080_;
                    if (screen != null) {
                        IPlatformScreenHelper screenHelper = Services.PLATFORM.getScreenHelper();
                        screenHelper.setFocused(this.previouslyFocusedWidget, true);
                        screen.m_7522_((GuiEventListener)this.previouslyFocusedWidget);
                    }
                    this.previouslyFocusedWidget = null;
                }
                minecraft.f_91068_.m_90926_(this.previousKeyboardRepeatEnabled);
            }
            String text = this.m_94155_();
            history.add(text);
        }
    }

    public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        if (this.m_94213_()) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.background.draw(poseStack, this.backgroundBounds);
        }
        super.m_6303_(poseStack, mouseX, mouseY, partialTicks);
    }

    public ImmutableRect2i getArea() {
        return this.area;
    }
}

