/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.network.packets;

import java.util.concurrent.CompletableFuture;
import mezz.jei.common.network.IPacketId;
import mezz.jei.common.network.PacketIdServer;
import mezz.jei.common.network.ServerPacketContext;
import mezz.jei.common.network.ServerPacketData;
import mezz.jei.common.network.packets.PacketJei;
import mezz.jei.common.util.ServerCommandUtil;
import mezz.jei.core.config.GiveMode;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class PacketGiveItemStack
extends PacketJei {
    private final ItemStack itemStack;
    private final GiveMode giveMode;

    public PacketGiveItemStack(ItemStack itemStack, GiveMode giveMode) {
        this.itemStack = itemStack;
        this.giveMode = giveMode;
    }

    @Override
    public IPacketId getPacketId() {
        return PacketIdServer.GIVE_ITEM;
    }

    @Override
    public void writePacketData(FriendlyByteBuf buf) {
        buf.m_130055_(this.itemStack);
        buf.m_130068_((Enum)this.giveMode);
    }

    public static CompletableFuture<Void> readPacketData(ServerPacketData data) {
        FriendlyByteBuf buf = data.buf();
        ItemStack itemStack = buf.m_130267_();
        GiveMode giveMode = (GiveMode)buf.m_130066_(GiveMode.class);
        ServerPacketContext context = data.context();
        ServerPlayer player = context.player();
        MinecraftServer server = player.f_8924_;
        return server.m_18707_(() -> ServerCommandUtil.executeGive(context, itemStack, giveMode));
    }
}

