/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.gui.elements;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.common.Constants;
import mezz.jei.common.gui.textures.JeiSpriteUploader;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;

public class DrawableSprite
implements IDrawableStatic {
    private final JeiSpriteUploader spriteUploader;
    private final ResourceLocation location;
    private final int width;
    private final int height;
    private int trimLeft;
    private int trimRight;
    private int trimTop;
    private int trimBottom;

    public DrawableSprite(JeiSpriteUploader spriteUploader, ResourceLocation location, int width, int height) {
        this.spriteUploader = spriteUploader;
        this.location = location;
        this.width = width;
        this.height = height;
    }

    public DrawableSprite trim(int left, int right, int top, int bottom) {
        this.trimLeft = left;
        this.trimRight = right;
        this.trimTop = top;
        this.trimBottom = bottom;
        return this;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void draw(PoseStack poseStack, int xOffset, int yOffset) {
        this.draw(poseStack, xOffset, yOffset, 0, 0, 0, 0);
    }

    @Override
    public void draw(PoseStack poseStack, int xOffset, int yOffset, int maskTop, int maskBottom, int maskLeft, int maskRight) {
        TextureAtlasSprite sprite = this.spriteUploader.m_118901_(this.location);
        int textureWidth = this.width;
        int textureHeight = this.height;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)Constants.LOCATION_JEI_GUI_TEXTURE_ATLAS);
        int x = xOffset + (maskLeft += this.trimLeft);
        int y = yOffset + (maskTop += this.trimTop);
        int width = textureWidth - (maskRight += this.trimRight) - maskLeft;
        int height = textureHeight - (maskBottom += this.trimBottom) - maskTop;
        float uSize = sprite.m_118410_() - sprite.m_118409_();
        float vSize = sprite.m_118412_() - sprite.m_118411_();
        float minU = sprite.m_118409_() + uSize * ((float)maskLeft / (float)textureWidth);
        float minV = sprite.m_118411_() + vSize * ((float)maskTop / (float)textureHeight);
        float maxU = sprite.m_118410_() - uSize * ((float)maskRight / (float)textureWidth);
        float maxV = sprite.m_118412_() - vSize * ((float)maskBottom / (float)textureHeight);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        bufferBuilder.m_85982_(matrix, (float)x, (float)(y + height), 0.0f).m_7421_(minU, maxV).m_5752_();
        bufferBuilder.m_85982_(matrix, (float)(x + width), (float)(y + height), 0.0f).m_7421_(maxU, maxV).m_5752_();
        bufferBuilder.m_85982_(matrix, (float)(x + width), (float)y, 0.0f).m_7421_(maxU, minV).m_5752_();
        bufferBuilder.m_85982_(matrix, (float)x, (float)y, 0.0f).m_7421_(minU, minV).m_5752_();
        tessellator.m_85914_();
    }
}

