/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.plugins.vanilla.anvil;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.vanilla.IJeiAnvilRecipe;
import mezz.jei.common.Constants;
import mezz.jei.common.plugins.vanilla.anvil.AnvilRecipeMaker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;

public class AnvilRecipeCategory
implements IRecipeCategory<IJeiAnvilRecipe> {
    private final IDrawable background;
    private final IDrawable icon;
    private final String leftSlotName = "leftSlot";
    private final String rightSlotName = "rightSlot";

    public AnvilRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(Constants.RECIPE_GUI_VANILLA, 0, 168, 125, 18).addPadding(0, 20, 0, 0).build();
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)Blocks.f_50322_));
    }

    @Override
    public RecipeType<IJeiAnvilRecipe> getRecipeType() {
        return RecipeTypes.ANVIL;
    }

    @Override
    public Component getTitle() {
        return Blocks.f_50322_.m_49954_();
    }

    @Override
    public IDrawable getBackground() {
        return this.background;
    }

    @Override
    public IDrawable getIcon() {
        return this.icon;
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, IJeiAnvilRecipe recipe, IFocusGroup focuses) {
        List<ItemStack> leftInputs = recipe.getLeftInputs();
        List<ItemStack> rightInputs = recipe.getRightInputs();
        List<ItemStack> outputs = recipe.getOutputs();
        IRecipeSlotBuilder leftInputSlot = ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addItemStacks(leftInputs)).setSlotName("leftSlot");
        IRecipeSlotBuilder rightInputSlot = ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 50, 1).addItemStacks(rightInputs)).setSlotName("rightSlot");
        IRecipeSlotBuilder outputSlot = (IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 108, 1).addItemStacks(outputs);
        if (leftInputs.size() == rightInputs.size()) {
            if (leftInputs.size() == outputs.size()) {
                builder.createFocusLink(leftInputSlot, rightInputSlot, outputSlot);
            }
        } else if (leftInputs.size() == outputs.size() && rightInputs.size() == 1) {
            builder.createFocusLink(leftInputSlot, outputSlot);
        } else if (rightInputs.size() == outputs.size() && leftInputs.size() == 1) {
            builder.createFocusLink(rightInputSlot, outputSlot);
        }
    }

    @Override
    public void draw(IJeiAnvilRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack poseStack, double mouseX, double mouseY) {
        Optional leftStack = recipeSlotsView.findSlotByName("leftSlot").flatMap(IRecipeSlotView::getDisplayedItemStack);
        Optional rightStack = recipeSlotsView.findSlotByName("rightSlot").flatMap(IRecipeSlotView::getDisplayedItemStack);
        if (leftStack.isEmpty() || rightStack.isEmpty()) {
            return;
        }
        int cost = AnvilRecipeMaker.findLevelsCost((ItemStack)leftStack.get(), (ItemStack)rightStack.get());
        String costText = cost < 0 ? "err" : Integer.toString(cost);
        String text = I18n.m_118938_((String)"container.repair.cost", (Object[])new Object[]{costText});
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        int mainColor = AnvilRecipeCategory.playerHasEnoughLevels(player, cost) ? -8323296 : -40864;
        this.drawRepairCost(minecraft, poseStack, text, mainColor);
    }

    private static boolean playerHasEnoughLevels(@Nullable LocalPlayer player, int cost) {
        if (player == null) {
            return true;
        }
        if (player.m_7500_()) {
            return true;
        }
        return cost < 40 && cost <= player.f_36078_;
    }

    private void drawRepairCost(Minecraft minecraft, PoseStack poseStack, String text, int mainColor) {
        int shadowColor = 0xFF000000 | (mainColor & 0xFCFCFC) >> 2;
        int width = minecraft.f_91062_.m_92895_(text);
        int x = this.background.getWidth() - 2 - width;
        int y = 27;
        minecraft.f_91062_.m_92883_(poseStack, text, (float)(x + 1), (float)y, shadowColor);
        minecraft.f_91062_.m_92883_(poseStack, text, (float)x, (float)(y + 1), shadowColor);
        minecraft.f_91062_.m_92883_(poseStack, text, (float)(x + 1), (float)(y + 1), shadowColor);
        minecraft.f_91062_.m_92883_(poseStack, text, (float)x, (float)y, mainColor);
    }
}

