/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.gui.elements;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.common.gui.HoverChecker;
import mezz.jei.common.gui.TooltipRenderer;
import mezz.jei.common.gui.elements.DrawableBlank;
import mezz.jei.common.gui.elements.GuiIconButton;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.common.input.IUserInputHandler;
import mezz.jei.common.input.UserInput;
import mezz.jei.common.util.ImmutableRect2i;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public abstract class GuiIconToggleButton {
    private final IDrawable offIcon;
    private final IDrawable onIcon;
    private final GuiIconButton button;
    private final HoverChecker hoverChecker;

    public GuiIconToggleButton(IDrawable offIcon, IDrawable onIcon, Textures textures) {
        this.offIcon = offIcon;
        this.onIcon = onIcon;
        this.button = new GuiIconButton(new DrawableBlank(0, 0), b -> {}, textures);
        this.hoverChecker = new HoverChecker();
        this.hoverChecker.updateBounds(this.button);
    }

    public void updateBounds(ImmutableRect2i area) {
        this.button.m_93674_(area.getWidth());
        this.button.setHeight(area.getHeight());
        this.button.f_93620_ = area.getX();
        this.button.f_93621_ = area.getY();
        this.hoverChecker.updateBounds(this.button);
    }

    public void draw(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.button.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        IDrawable icon = this.isIconToggledOn() ? this.onIcon : this.offIcon;
        icon.draw(poseStack, this.button.f_93620_ + 2, this.button.f_93621_ + 2);
    }

    public final boolean isMouseOver(double mouseX, double mouseY) {
        return this.hoverChecker.checkHover(mouseX, mouseY);
    }

    public IUserInputHandler createInputHandler() {
        return new UserInputHandler();
    }

    public final void drawTooltips(PoseStack poseStack, int mouseX, int mouseY) {
        if (this.isMouseOver(mouseX, mouseY)) {
            ArrayList<Component> tooltip = new ArrayList<Component>();
            this.getTooltips(tooltip);
            TooltipRenderer.drawHoveringText(poseStack, tooltip, mouseX, mouseY);
        }
    }

    protected abstract void getTooltips(List<Component> var1);

    protected abstract boolean isIconToggledOn();

    protected abstract boolean onMouseClicked(UserInput var1);

    private class UserInputHandler
    implements IUserInputHandler {
        private UserInputHandler() {
        }

        @Override
        public final Optional<IUserInputHandler> handleUserInput(Screen screen, UserInput input, IInternalKeyMappings keyBindings) {
            if (GuiIconToggleButton.this.isMouseOver(input.getMouseX(), input.getMouseY())) {
                IUserInputHandler handler = GuiIconToggleButton.this.button.createInputHandler();
                return handler.handleUserInput(screen, input, keyBindings).flatMap(handled -> {
                    if (GuiIconToggleButton.this.onMouseClicked(input)) {
                        return Optional.of(this);
                    }
                    return Optional.empty();
                });
            }
            return Optional.empty();
        }
    }
}

