/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.util;

import java.util.Collection;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.common.ingredients.RegisteredIngredients;
import mezz.jei.common.platform.IPlatformModHelper;
import mezz.jei.common.platform.IPlatformRegistry;
import mezz.jei.common.platform.Services;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public final class ErrorUtil {
    private ErrorUtil() {
    }

    public static <T> String getIngredientInfo(T ingredient, IIngredientType<T> ingredientType, RegisteredIngredients registeredIngredients) {
        IIngredientHelper<T> ingredientHelper = registeredIngredients.getIngredientHelper(ingredientType);
        return ingredientHelper.getErrorInfo(ingredient);
    }

    public static String getItemStackInfo(@Nullable ItemStack itemStack) {
        Object itemName;
        if (itemStack == null) {
            return "null";
        }
        Item item = itemStack.m_41720_();
        IPlatformRegistry<Item> itemRegistry = Services.PLATFORM.getRegistry(Registry.f_122904_);
        ResourceLocation registryName = itemRegistry.getRegistryName(item);
        if (registryName != null) {
            itemName = registryName.toString();
        } else if (item instanceof BlockItem) {
            IPlatformRegistry<Block> blockRegistry;
            ResourceLocation blockRegistryName;
            Block block = ((BlockItem)item).m_40614_();
            String blockName = block == null ? "null" : ((blockRegistryName = (blockRegistry = Services.PLATFORM.getRegistry(Registry.f_122901_)).getRegistryName(block)) != null ? blockRegistryName.toString() : block.getClass().getName());
            itemName = "BlockItem(" + blockName + ")";
        } else {
            itemName = item.getClass().getName();
        }
        CompoundTag nbt = itemStack.m_41783_();
        if (nbt != null) {
            return itemStack + " " + (String)itemName + " nbt:" + nbt;
        }
        return itemStack + " " + (String)itemName;
    }

    public static void checkNotEmpty(ItemStack itemStack) {
        if (itemStack == null) {
            throw new NullPointerException("ItemStack must not be null.");
        }
        if (itemStack.m_41619_()) {
            String info = ErrorUtil.getItemStackInfo(itemStack);
            throw new IllegalArgumentException("ItemStack value must not be empty. " + info);
        }
    }

    public static void checkNotEmpty(ItemStack itemStack, String name) {
        if (itemStack == null) {
            throw new NullPointerException(name + " must not be null.");
        }
        if (itemStack.m_41619_()) {
            String info = ErrorUtil.getItemStackInfo(itemStack);
            throw new IllegalArgumentException("ItemStack " + name + " must not be empty. " + info);
        }
    }

    public static <T> void checkNotEmpty(T[] values, String name) {
        if (values == null) {
            throw new NullPointerException(name + " must not be null.");
        }
        if (values.length <= 0) {
            throw new IllegalArgumentException(name + " must not be empty.");
        }
        for (T value : values) {
            if (value != null) continue;
            throw new NullPointerException(name + " must not contain null values.");
        }
    }

    public static void checkNotEmpty(Collection<?> values, String name) {
        if (values == null) {
            throw new NullPointerException(name + " must not be null.");
        }
        if (values.isEmpty()) {
            throw new IllegalArgumentException(name + " must not be empty.");
        }
        if (!(values instanceof NonNullList)) {
            for (Object value : values) {
                if (value != null) continue;
                throw new NullPointerException(name + " must not contain null values.");
            }
        }
    }

    public static <T> void checkNotNull(@Nullable T object, String name) {
        if (object == null) {
            throw new NullPointerException(name + " must not be null.");
        }
    }

    public static void checkNotNull(Collection<?> values, String name) {
        if (values == null) {
            throw new NullPointerException(name + " must not be null.");
        }
        if (!(values instanceof NonNullList)) {
            for (Object value : values) {
                if (value != null) continue;
                throw new NullPointerException(name + " must not contain null values.");
            }
        }
    }

    public static void assertMainThread() {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft != null && !minecraft.m_18695_()) {
            Thread currentThread = Thread.currentThread();
            throw new IllegalStateException("A JEI API method is being called by another mod from the wrong thread:\n" + currentThread + "\nIt must be called on the main thread by using Minecraft.addScheduledTask.");
        }
    }

    public static <T> ReportedException createRenderIngredientException(Throwable throwable, T ingredient, RegisteredIngredients registeredIngredients) {
        IIngredientType ingredientType = registeredIngredients.getIngredientType(ingredient);
        IIngredientHelper ingredientHelper = registeredIngredients.getIngredientHelper(ingredientType);
        CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable, (String)"Rendering ingredient");
        CrashReportCategory ingredientCategory = crashreport.m_127514_("Ingredient being rendered");
        IPlatformModHelper modHelper = Services.PLATFORM.getModHelper();
        ingredientCategory.m_128165_("Mod Name", () -> {
            String modId = ingredientHelper.getDisplayModId(ingredient);
            return modHelper.getModNameForModId(modId);
        });
        ingredientCategory.m_128165_("Registry Name", () -> ingredientHelper.getResourceLocation(ingredient).toString());
        ingredientCategory.m_128165_("Display Name", () -> ingredientHelper.getDisplayName(ingredient));
        ingredientCategory.m_128165_("String Name", ingredient::toString);
        CrashReportCategory jeiCategory = crashreport.m_127514_("JEI render details");
        jeiCategory.m_128165_("Unique Id (for Blacklist)", () -> ingredientHelper.getUniqueId(ingredient, UidContext.Ingredient));
        jeiCategory.m_128165_("Ingredient Type", () -> ingredientType.getIngredientClass().toString());
        jeiCategory.m_128165_("Error Info", () -> ingredientHelper.getErrorInfo(ingredient));
        throw new ReportedException(crashreport);
    }
}

