/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.util;

import mezz.jei.common.network.IConnectionToServer;
import mezz.jei.common.network.packets.PacketGiveItemStack;
import mezz.jei.common.network.packets.PacketSetHotbarItemStack;
import mezz.jei.common.platform.IPlatformRegistry;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.common.util.GiveAmount;
import mezz.jei.common.util.ServerCommandUtil;
import mezz.jei.core.config.GiveMode;
import mezz.jei.core.config.IClientConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class CommandUtil {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IClientConfig clientConfig;
    private final IConnectionToServer serverConnection;

    public CommandUtil(IClientConfig clientConfig, IConnectionToServer serverConnection) {
        this.clientConfig = clientConfig;
        this.serverConnection = serverConnection;
    }

    public void giveStack(ItemStack itemStack, GiveAmount giveAmount) {
        GiveMode giveMode = this.clientConfig.getGiveMode();
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            LOGGER.error("Can't give stack, there is no player");
            return;
        }
        int amount = giveAmount.getAmountForStack(itemStack);
        if (minecraft.f_91080_ instanceof CreativeModeInventoryScreen && giveMode == GiveMode.MOUSE_PICKUP) {
            ItemStack sendStack = CommandUtil.copyWithSize(itemStack, amount);
            ServerCommandUtil.mousePickupItemStack((Player)player, sendStack);
        } else if (this.serverConnection.isJeiOnServer()) {
            ItemStack sendStack = CommandUtil.copyWithSize(itemStack, amount);
            PacketGiveItemStack packet = new PacketGiveItemStack(sendStack, giveMode);
            this.serverConnection.sendPacketToServer(packet);
        } else {
            CommandUtil.giveStackVanilla(itemStack, amount);
        }
    }

    public void setHotbarStack(ItemStack itemStack, int hotbarSlot) {
        if (this.serverConnection.isJeiOnServer()) {
            ItemStack sendStack = CommandUtil.copyWithSize(itemStack, itemStack.m_41741_());
            PacketSetHotbarItemStack packet = new PacketSetHotbarItemStack(sendStack, hotbarSlot);
            this.serverConnection.sendPacketToServer(packet);
        }
    }

    private static void giveStackVanilla(ItemStack itemStack, int amount) {
        if (itemStack.m_41619_()) {
            String stackInfo = ErrorUtil.getItemStackInfo(itemStack);
            LOGGER.error("Empty itemStack: {}", (Object)stackInfo, (Object)new IllegalArgumentException());
            return;
        }
        Item item = itemStack.m_41720_();
        IPlatformRegistry<Item> itemRegistry = Services.PLATFORM.getRegistry(Registry.f_122904_);
        ResourceLocation itemResourceLocation = itemRegistry.getRegistryName(item);
        ErrorUtil.checkNotNull(itemResourceLocation, "itemStack.getItem().getRegistryName()");
        LocalPlayer sender = Minecraft.m_91087_().f_91074_;
        if (sender != null) {
            if (sender.m_20203_().m_6761_(2)) {
                CommandUtil.sendGiveAction(sender, itemStack, amount);
            } else if (sender.m_7500_()) {
                CommandUtil.sendCreativeInventoryActions(sender, itemStack, amount);
            } else {
                CommandUtil.sendGiveAction(sender, itemStack, amount);
            }
        }
    }

    private static void sendGiveAction(LocalPlayer sender, ItemStack itemStack, int amount) {
        Object[] commandParameters = ServerCommandUtil.getGiveCommandParameters((Player)sender, itemStack, amount);
        String fullCommand = "/give " + StringUtils.join((Object[])commandParameters, (String)" ");
        CommandUtil.sendChatMessage(sender, fullCommand);
    }

    private static void sendChatMessage(LocalPlayer sender, String chatMessage) {
        if (chatMessage.length() <= 256) {
            sender.m_108739_(chatMessage);
        } else {
            MutableComponent errorMessage = Component.m_237115_((String)"jei.chat.error.command.too.long");
            errorMessage.m_7383_().m_131157_(ChatFormatting.RED);
            sender.m_5661_((Component)errorMessage, false);
            MutableComponent chatMessageComponent = Component.m_237113_((String)chatMessage);
            chatMessageComponent.m_7383_().m_131157_(ChatFormatting.RED);
            sender.m_5661_((Component)chatMessageComponent, false);
        }
    }

    private static void sendCreativeInventoryActions(LocalPlayer sender, ItemStack stack, int amount) {
        for (int i = 0; i < sender.m_150109_().f_35974_.size() && amount > 0; ++i) {
            ItemStack currentStack = (ItemStack)sender.m_150109_().f_35974_.get(i);
            if (currentStack.m_41619_()) {
                ItemStack sendAllRemaining = CommandUtil.copyWithSize(stack, amount);
                CommandUtil.sendSlotPacket(sendAllRemaining, i);
                amount = 0;
                continue;
            }
            if (!currentStack.m_41656_(stack) || currentStack.m_41741_() <= currentStack.m_41613_()) continue;
            int canAdd = Math.min(currentStack.m_41741_() - currentStack.m_41613_(), amount);
            ItemStack fillRemainingSpace = CommandUtil.copyWithSize(stack, canAdd + currentStack.m_41613_());
            CommandUtil.sendSlotPacket(fillRemainingSpace, i);
            amount -= canAdd;
        }
        if (amount > 0) {
            ItemStack toDrop = CommandUtil.copyWithSize(stack, amount);
            CommandUtil.sendSlotPacket(toDrop, -1);
        }
    }

    private static void sendSlotPacket(ItemStack stack, int mainInventorySlot) {
        if (mainInventorySlot < 9 && mainInventorySlot != -1) {
            mainInventorySlot += 36;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        MultiPlayerGameMode playerController = minecraft.f_91072_;
        if (playerController != null) {
            playerController.m_105241_(stack, mainInventorySlot);
        } else {
            LOGGER.error("Cannot send slot packet, minecraft.playerController is null");
        }
    }

    private static ItemStack copyWithSize(ItemStack itemStack, int size) {
        if (size == 0) {
            return ItemStack.f_41583_;
        }
        ItemStack copy = itemStack.m_41777_();
        copy.m_41764_(size);
        return copy;
    }
}

