/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.input;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.Collection;
import java.util.Optional;
import mezz.jei.common.input.InputType;
import mezz.jei.common.input.MouseUtil;
import mezz.jei.common.input.keys.IJeiKeyMapping;
import mezz.jei.common.platform.IPlatformInputHelper;
import mezz.jei.common.platform.Services;
import net.minecraft.SharedConstants;
import net.minecraft.client.KeyMapping;

public class UserInput {
    private final InputConstants.Key key;
    private final double mouseX;
    private final double mouseY;
    private final int modifiers;
    private final InputType clickState;

    public static UserInput fromVanilla(int keyCode, int scanCode, int modifiers, InputType inputType) {
        InputConstants.Key input = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        return new UserInput(input, MouseUtil.getX(), MouseUtil.getY(), modifiers, inputType);
    }

    public static Optional<UserInput> fromVanilla(double mouseX, double mouseY, int mouseButton, InputType inputType) {
        if (mouseButton < 0) {
            return Optional.empty();
        }
        InputConstants.Key input = InputConstants.Type.MOUSE.m_84895_(mouseButton);
        UserInput userInput = new UserInput(input, mouseX, mouseY, 0, inputType);
        return Optional.of(userInput);
    }

    public UserInput(InputConstants.Key key, double mouseX, double mouseY, int modifiers, InputType clickState) {
        this.key = key;
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.modifiers = modifiers;
        this.clickState = clickState;
    }

    public InputConstants.Key getKey() {
        return this.key;
    }

    public double getMouseX() {
        return this.mouseX;
    }

    public double getMouseY() {
        return this.mouseY;
    }

    public InputType getClickState() {
        return this.clickState;
    }

    public boolean isSimulate() {
        return this.clickState == InputType.SIMULATE;
    }

    public boolean isMouse() {
        return this.key.m_84868_() == InputConstants.Type.MOUSE;
    }

    public boolean isKeyboard() {
        return this.key.m_84868_() == InputConstants.Type.KEYSYM;
    }

    public boolean isAllowedChatCharacter() {
        return this.isKeyboard() && SharedConstants.m_136188_((char)((char)this.key.m_84873_()));
    }

    public boolean is(IJeiKeyMapping keyMapping) {
        return keyMapping.isActiveAndMatches(this.key);
    }

    public boolean is(KeyMapping keyMapping) {
        IPlatformInputHelper inputHelper = Services.PLATFORM.getInputHelper();
        return inputHelper.isActiveAndMatches(keyMapping, this.key);
    }

    public boolean is(Collection<IJeiKeyMapping> keyMappings) {
        return keyMappings.stream().anyMatch(this::is);
    }

    public boolean callVanilla(MouseOverable mouseOverable, MouseClickable mouseClickable) {
        if (this.key.m_84868_() == InputConstants.Type.MOUSE && mouseOverable.isMouseOver(this.mouseX, this.mouseY)) {
            if (this.isSimulate()) {
                return true;
            }
            return mouseClickable.mouseClicked(this.mouseX, this.mouseY, this.key.m_84873_());
        }
        return false;
    }

    public boolean callVanilla(KeyPressable keyPressable) {
        if (this.key.m_84868_() == InputConstants.Type.KEYSYM) {
            if (this.isSimulate()) {
                return true;
            }
            return keyPressable.keyPressed(this.key.m_84873_(), 0, this.modifiers);
        }
        return false;
    }

    public boolean callVanilla(MouseOverable mouseOverable, MouseClickable mouseClickable, KeyPressable keyPressable) {
        return switch (this.key.m_84868_()) {
            case InputConstants.Type.KEYSYM -> this.callVanilla(keyPressable);
            case InputConstants.Type.MOUSE -> this.callVanilla(mouseOverable, mouseClickable);
            default -> false;
        };
    }

    @FunctionalInterface
    public static interface MouseOverable {
        public boolean isMouseOver(double var1, double var3);
    }

    @FunctionalInterface
    public static interface MouseClickable {
        public boolean mouseClicked(double var1, double var3, int var5);
    }

    @FunctionalInterface
    public static interface KeyPressable {
        public boolean keyPressed(int var1, int var2, int var3);
    }
}

