/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.gui;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.gui.handlers.IGlobalGuiHandler;
import mezz.jei.api.gui.handlers.IGuiClickableArea;
import mezz.jei.api.gui.handlers.IGuiProperties;
import mezz.jei.api.gui.handlers.IScreenHandler;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.common.gui.GuiContainerHandlers;
import mezz.jei.common.ingredients.RegisteredIngredients;
import mezz.jei.common.ingredients.TypedIngredient;
import mezz.jei.common.input.ClickedIngredient;
import mezz.jei.common.input.IClickedIngredient;
import mezz.jei.common.platform.IPlatformScreenHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.MathUtil;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class GuiScreenHelper {
    private final RegisteredIngredients registeredIngredients;
    private final List<IGlobalGuiHandler> globalGuiHandlers;
    private final GuiContainerHandlers guiContainerHandlers;
    private final Map<Class<?>, IGhostIngredientHandler<?>> ghostIngredientHandlers;
    private final Map<Class<?>, IScreenHandler<?>> guiScreenHandlers;
    private Set<ImmutableRect2i> guiExclusionAreas = Collections.emptySet();

    public GuiScreenHelper(RegisteredIngredients registeredIngredients, List<IGlobalGuiHandler> globalGuiHandlers, GuiContainerHandlers guiContainerHandlers, Map<Class<?>, IGhostIngredientHandler<?>> ghostIngredientHandlers, Map<Class<?>, IScreenHandler<?>> guiScreenHandlers) {
        this.registeredIngredients = registeredIngredients;
        this.globalGuiHandlers = globalGuiHandlers;
        this.guiContainerHandlers = guiContainerHandlers;
        this.ghostIngredientHandlers = ghostIngredientHandlers;
        this.guiScreenHandlers = guiScreenHandlers;
    }

    @Nullable
    public <T extends Screen> IGuiProperties getGuiProperties(@Nullable T screen) {
        if (screen == null) {
            return null;
        }
        IScreenHandler<?> handler = this.guiScreenHandlers.get(screen.getClass());
        if (handler != null) {
            return handler.apply(screen);
        }
        for (Map.Entry<Class<?>, IScreenHandler<?>> entry : this.guiScreenHandlers.entrySet()) {
            IScreenHandler<?> handler2;
            Class<?> guiScreenClass = entry.getKey();
            if (!guiScreenClass.isInstance(screen) || (handler2 = entry.getValue()) == null) continue;
            return handler2.apply(screen);
        }
        return null;
    }

    public boolean updateGuiExclusionAreas(Screen screen) {
        Set<Rect2i> guiAreas = this.getPluginsExclusionAreas(screen);
        if (!MathUtil.equalRects(guiAreas, this.guiExclusionAreas)) {
            this.guiExclusionAreas = guiAreas.stream().map(ImmutableRect2i::new).collect(Collectors.toUnmodifiableSet());
            return true;
        }
        return false;
    }

    public Set<ImmutableRect2i> getGuiExclusionAreas() {
        return this.guiExclusionAreas;
    }

    public boolean isInGuiExclusionArea(double mouseX, double mouseY) {
        return MathUtil.contains(this.guiExclusionAreas, mouseX, mouseY);
    }

    private Set<Rect2i> getPluginsExclusionAreas(Screen screen) {
        Set<Rect2i> globalGuiHandlerExclusionAreas = this.globalGuiHandlers.stream().map(IGlobalGuiHandler::getGuiExtraAreas).flatMap(Collection::stream).collect(Collectors.toSet());
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen guiContainer = (AbstractContainerScreen)screen;
            Collection<Rect2i> guiExtraAreas = this.guiContainerHandlers.getGuiExtraAreas(guiContainer);
            HashSet<Rect2i> areas = new HashSet<Rect2i>(guiExtraAreas);
            areas.addAll(globalGuiHandlerExclusionAreas);
            return areas;
        }
        return globalGuiHandlerExclusionAreas;
    }

    public <T extends AbstractContainerScreen<?>> Stream<IClickedIngredient<?>> getPluginsIngredientUnderMouse(T guiContainer, double mouseX, double mouseY) {
        return Stream.concat(this.guiContainerHandlers.getActiveGuiHandlerStream(guiContainer).map(a -> a.getIngredientUnderMouse(guiContainer, mouseX, mouseY)), this.globalGuiHandlers.stream().map(a -> a.getIngredientUnderMouse(mouseX, mouseY))).map(i -> this.createClickedIngredient(i, guiContainer)).flatMap(Optional::stream);
    }

    @Nullable
    public <T extends Screen> IGhostIngredientHandler<T> getGhostIngredientHandler(T guiScreen) {
        IGhostIngredientHandler<?> handler = this.ghostIngredientHandlers.get(guiScreen.getClass());
        if (handler != null) {
            return handler;
        }
        for (Map.Entry<Class<?>, IGhostIngredientHandler<?>> entry : this.ghostIngredientHandlers.entrySet()) {
            IGhostIngredientHandler<?> handler2;
            Class<?> guiScreenClass = entry.getKey();
            if (!guiScreenClass.isInstance(guiScreen) || (handler2 = entry.getValue()) == null) continue;
            return handler2;
        }
        return null;
    }

    private <T> Optional<IClickedIngredient<?>> createClickedIngredient(@Nullable T ingredient, AbstractContainerScreen<?> guiContainer) {
        if (ingredient == null) {
            return Optional.empty();
        }
        return TypedIngredient.create(this.registeredIngredients, ingredient).map(typedIngredient -> {
            ImmutableRect2i area = GuiScreenHelper.getSlotArea(typedIngredient, guiContainer);
            return new ClickedIngredient(typedIngredient, area, false, false);
        });
    }

    public Optional<IGuiClickableArea> getGuiClickableArea(AbstractContainerScreen<?> guiContainer, double guiMouseX, double guiMouseY) {
        return this.guiContainerHandlers.getGuiClickableArea(guiContainer, guiMouseX, guiMouseY);
    }

    @Nullable
    public static <T> ImmutableRect2i getSlotArea(ITypedIngredient<T> typedIngredient, AbstractContainerScreen<?> guiContainer) {
        IPlatformScreenHelper screenHelper = Services.PLATFORM.getScreenHelper();
        Slot slotUnderMouse = screenHelper.getSlotUnderMouse(guiContainer);
        if (slotUnderMouse == null) {
            return null;
        }
        return typedIngredient.getIngredient(VanillaTypes.ITEM_STACK).filter(i -> ItemStack.m_41728_((ItemStack)slotUnderMouse.m_7993_(), (ItemStack)i)).map(i -> new ImmutableRect2i(screenHelper.getGuiLeft(guiContainer) + slotUnderMouse.f_40220_, screenHelper.getGuiTop(guiContainer) + slotUnderMouse.f_40221_, 16, 16)).orElse(null);
    }
}

