/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.config.file;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import mezz.jei.common.config.file.ConfigCategory;
import mezz.jei.common.config.file.ConfigCategoryBuilder;
import mezz.jei.common.config.file.ConfigSerializer;
import mezz.jei.common.config.file.FileWatcher;
import mezz.jei.common.config.file.IConfigSchema;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class ConfigSchema
implements IConfigSchema {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Path path;
    private final @Unmodifiable Map<String, ConfigCategory> categories;
    private final AtomicBoolean needsLoad = new AtomicBoolean(true);

    public ConfigSchema(Path path, List<ConfigCategoryBuilder> categoryBuilders) {
        this.path = path;
        LinkedHashMap<String, ConfigCategory> map = new LinkedHashMap<String, ConfigCategory>();
        for (ConfigCategoryBuilder builder : categoryBuilders) {
            ConfigCategory category = builder.build(this);
            map.put(category.getName(), category);
        }
        this.categories = Collections.unmodifiableMap(map);
    }

    @Override
    public void loadIfNeeded() {
        if (!this.needsLoad.get()) {
            return;
        }
        this.needsLoad.set(false);
        if (Files.exists(this.path, new LinkOption[0])) {
            try {
                ConfigSerializer.load(this);
            }
            catch (IOException e) {
                LOGGER.error("Failed to load config schema for: %s".formatted(this.path), (Throwable)e);
            }
        }
    }

    private void onFileChanged() {
        this.needsLoad.set(true);
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Nullable
    public ConfigCategory getCategory(String categoryName) {
        return this.categories.get(categoryName);
    }

    public Collection<ConfigCategory> getCategories() {
        return this.categories.values();
    }

    public Set<String> getCategoryNames() {
        return this.categories.keySet();
    }

    @Override
    public void register(Path configFile) {
        Path configPath = this.getPath();
        if (!Files.exists(configPath, new LinkOption[0])) {
            try {
                Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
                ConfigSerializer.save(this);
            }
            catch (IOException e) {
                LOGGER.error("Failed to create config file: '{}'", (Object)configFile, (Object)e);
            }
        }
        try {
            FileWatcher fileWatcher = new FileWatcher(Map.of(configPath, this::onFileChanged));
            Thread thread = new Thread(fileWatcher::run, "JEI Config file watcher");
            thread.start();
        }
        catch (IOException e) {
            LOGGER.error("Failed to create FileWatcher Thread for config file: '{}'", (Object)configFile, (Object)e);
        }
    }
}

