/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.config;

import java.io.IOException;
import java.nio.file.Path;
import mezz.jei.common.config.ClientConfig;
import mezz.jei.common.config.IIngredientFilterConfig;
import mezz.jei.common.config.IIngredientGridConfig;
import mezz.jei.common.config.IModIdFormatConfig;
import mezz.jei.common.config.IngredientFilterConfig;
import mezz.jei.common.config.IngredientGridConfig;
import mezz.jei.common.config.ModIdFormatConfig;
import mezz.jei.common.config.file.ConfigSchemaBuilder;
import mezz.jei.common.config.file.IConfigSchema;
import mezz.jei.common.gui.overlay.options.HorizontalAlignment;
import mezz.jei.core.config.IClientConfig;
import mezz.jei.core.util.PathUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JEIClientConfigs {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IClientConfig clientConfig;
    private final IIngredientFilterConfig filterConfig;
    private final IModIdFormatConfig modIdFormat;
    private final IIngredientGridConfig ingredientListConfig;
    private final IIngredientGridConfig bookmarkListConfig;
    private final IConfigSchema schema;

    public JEIClientConfigs(Path configFile) {
        ConfigSchemaBuilder builder = new ConfigSchemaBuilder();
        this.clientConfig = new ClientConfig(builder);
        this.filterConfig = new IngredientFilterConfig(builder);
        this.modIdFormat = new ModIdFormatConfig(builder);
        this.ingredientListConfig = new IngredientGridConfig("IngredientList", builder, HorizontalAlignment.RIGHT);
        this.bookmarkListConfig = new IngredientGridConfig("BookmarkList", builder, HorizontalAlignment.LEFT);
        this.schema = builder.build(configFile);
    }

    public void register(Path configDir, Path configFile) {
        Path oldConfigFile = configDir.resolve("jei-client.toml");
        try {
            if (PathUtil.migrateConfigLocation(configFile, oldConfigFile)) {
                LOGGER.info("Successfully migrated config file from '{}' to new location '{}'", (Object)oldConfigFile, (Object)configFile);
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to migrate config file from '{}' to new location '{}'", (Object)oldConfigFile, (Object)configFile, (Object)e);
        }
        this.schema.register(configFile);
    }

    public IClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public IIngredientFilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    public IIngredientGridConfig getIngredientListConfig() {
        return this.ingredientListConfig;
    }

    public IIngredientGridConfig getBookmarkListConfig() {
        return this.bookmarkListConfig;
    }

    public IModIdFormatConfig getModIdFormat() {
        return this.modIdFormat;
    }
}

