/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.input.mouse.handlers;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.Optional;
import mezz.jei.config.KeyBindings;
import mezz.jei.forge.events.DebugRestartJeiEvent;
import mezz.jei.input.GuiTextFieldFilter;
import mezz.jei.input.TextHistory;
import mezz.jei.input.UserInput;
import mezz.jei.input.mouse.IUserInputHandler;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class TextFieldInputHandler
implements IUserInputHandler {
    private final GuiTextFieldFilter textFieldFilter;

    public TextFieldInputHandler(GuiTextFieldFilter textFieldFilter) {
        this.textFieldFilter = textFieldFilter;
    }

    @Override
    public Optional<IUserInputHandler> handleUserInput(Screen screen, UserInput input) {
        if (this.handleUserInputBoolean(input)) {
            return Optional.of(this);
        }
        return Optional.empty();
    }

    private boolean handleUserInputBoolean(UserInput input) {
        if (input.is(KeyBindings.enterKey) || input.is(KeyBindings.escapeKey)) {
            return this.handleSetFocused(input, false);
        }
        if (input.is(KeyBindings.focusSearch)) {
            return this.handleSetFocused(input, true);
        }
        if (input.is(KeyBindings.hoveredClearSearchBar) && this.textFieldFilter.m_5953_(input.getMouseX(), input.getMouseY())) {
            return this.handleHoveredClearSearchBar(input);
        }
        if (input.callVanilla(this.textFieldFilter::m_5953_, (arg_0, arg_1, arg_2) -> ((GuiTextFieldFilter)this.textFieldFilter).m_6375_(arg_0, arg_1, arg_2), (arg_0, arg_1, arg_2) -> ((GuiTextFieldFilter)this.textFieldFilter).m_7933_(arg_0, arg_1, arg_2))) {
            return true;
        }
        if (input.is(KeyBindings.previousSearch)) {
            return this.handleNavigateHistory(input, TextHistory.Direction.PREVIOUS);
        }
        if (input.is(KeyBindings.nextSearch)) {
            return this.handleNavigateHistory(input, TextHistory.Direction.NEXT);
        }
        if (input.is(KeyBindings.reloadJeiOverTextFilter)) {
            MinecraftForge.EVENT_BUS.post((Event)new DebugRestartJeiEvent());
        }
        return this.textFieldFilter.m_94204_() && input.isAllowedChatCharacter();
    }

    private boolean handleSetFocused(UserInput input, boolean focused) {
        if (this.textFieldFilter.m_93696_() != focused) {
            if (!input.isSimulate()) {
                this.textFieldFilter.m_93692_(focused);
            }
            return true;
        }
        return false;
    }

    private boolean handleHoveredClearSearchBar(UserInput input) {
        if (!input.isSimulate()) {
            this.textFieldFilter.m_94144_("");
            this.textFieldFilter.m_93692_(true);
        }
        return true;
    }

    private boolean handleNavigateHistory(UserInput input, TextHistory.Direction direction) {
        if (this.textFieldFilter.m_93696_()) {
            return this.textFieldFilter.getHistory(direction).map(newText -> {
                if (!input.isSimulate()) {
                    this.textFieldFilter.m_94144_((String)newText);
                }
                return true;
            }).orElse(false);
        }
        return false;
    }

    @Override
    public void handleMouseClickedOut(InputConstants.Key input) {
        this.textFieldFilter.m_93692_(false);
    }
}

