/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.forge.config;

import mezz.jei.config.IIngredientGridConfig;
import mezz.jei.gui.overlay.HorizontalAlignment;
import mezz.jei.gui.overlay.NavigationVisibility;
import mezz.jei.gui.overlay.VerticalAlignment;
import net.minecraftforge.common.ForgeConfigSpec;

public class IngredientGridConfig
implements IIngredientGridConfig {
    private static final int minNumRows = 1;
    private static final int defaultNumRows = 16;
    private static final int largestNumRows = 100;
    private static final int minNumColumns = 4;
    private static final int defaultNumColumns = 9;
    private static final int largestNumColumns = 100;
    private final ForgeConfigSpec.IntValue maxRows;
    private final ForgeConfigSpec.IntValue maxColumns;
    private final ForgeConfigSpec.EnumValue<HorizontalAlignment> horizontalAlignment;
    private final ForgeConfigSpec.EnumValue<VerticalAlignment> verticalAlignment;
    private final ForgeConfigSpec.EnumValue<NavigationVisibility> buttonNavigationVisibility;
    private final ForgeConfigSpec.BooleanValue drawBackground;

    public IngredientGridConfig(String categoryName, ForgeConfigSpec.Builder builder, HorizontalAlignment defaultHorizontalAlignment) {
        builder.push(categoryName);
        builder.comment("Max number of rows shown");
        this.maxRows = builder.defineInRange("MaxRows", 16, 1, 100);
        builder.comment("Max number of columns shown");
        this.maxColumns = builder.defineInRange("MaxColumns", 9, 4, 100);
        builder.comment("Horizontal alignment of the ingredient grid inside the available area");
        this.horizontalAlignment = builder.defineEnum("HorizontalAlignment", (Enum)defaultHorizontalAlignment);
        builder.comment("Horizontal alignment of the ingredient grid inside the available area");
        this.verticalAlignment = builder.defineEnum("VerticalAlignment", (Enum)VerticalAlignment.TOP);
        builder.comment("Visibility of the top page buttons. Use AUTO_HIDE to only show it when there are multiple pages.");
        this.buttonNavigationVisibility = builder.defineEnum("ButtonNavigationVisibility", (Enum)NavigationVisibility.ENABLED);
        builder.comment("Set to true to draw a background texture behind the gui.");
        this.drawBackground = builder.define("DrawBackground", false);
        builder.pop();
    }

    @Override
    public int getMinColumns() {
        return 4;
    }

    @Override
    public int getMinRows() {
        return 1;
    }

    @Override
    public HorizontalAlignment getHorizontalAlignment() {
        return (HorizontalAlignment)((Object)this.horizontalAlignment.get());
    }

    @Override
    public VerticalAlignment getVerticalAlignment() {
        return (VerticalAlignment)((Object)this.verticalAlignment.get());
    }

    @Override
    public boolean drawBackground() {
        return (Boolean)this.drawBackground.get();
    }

    @Override
    public int getMaxColumns() {
        return (Integer)this.maxColumns.get();
    }

    @Override
    public int getMaxRows() {
        return (Integer)this.maxRows.get();
    }

    @Override
    public NavigationVisibility getButtonNavigationVisibility() {
        return (NavigationVisibility)((Object)this.buttonNavigationVisibility.get());
    }
}

