/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.plugins.debug;

import java.util.Collections;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.common.config.ClientConfig;
import mezz.jei.common.platform.IPlatformFluidHelperInternal;
import mezz.jei.common.platform.IPlatformRegistry;
import mezz.jei.common.platform.IPlatformScreenHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.plugins.debug.DebugFocusRecipeCategory;
import mezz.jei.common.plugins.debug.DebugGhostIngredientHandler;
import mezz.jei.common.plugins.debug.DebugRecipe;
import mezz.jei.common.plugins.debug.DebugRecipeCategory;
import mezz.jei.common.plugins.debug.FluidSubtypeHandlerTest;
import mezz.jei.common.plugins.debug.LegacyDebugRecipeCategory;
import mezz.jei.common.plugins.jei.ingredients.DebugIngredient;
import mezz.jei.common.plugins.jei.ingredients.DebugIngredientHelper;
import mezz.jei.common.plugins.jei.ingredients.DebugIngredientListFactory;
import mezz.jei.common.plugins.jei.ingredients.DebugIngredientRenderer;
import mezz.jei.common.util.ErrorUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.BrewingStandScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

@JeiPlugin
public class JeiDebugPlugin
implements IModPlugin {
    @Nullable
    public static IIngredientManager ingredientManager;
    @Nullable
    public static IJeiRuntime jeiRuntime;

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("jei", "debug");
    }

    public void registerIngredients(IModIngredientRegistration registration) {
        if (ClientConfig.getInstance().isDebugModeEnabled()) {
            DebugIngredientHelper ingredientHelper = new DebugIngredientHelper();
            DebugIngredientRenderer ingredientRenderer = new DebugIngredientRenderer(ingredientHelper);
            registration.register(DebugIngredient.TYPE, Collections.emptyList(), (IIngredientHelper)ingredientHelper, (IIngredientRenderer)ingredientRenderer);
        }
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        if (ClientConfig.getInstance().isDebugModeEnabled()) {
            IJeiHelpers jeiHelpers = registration.getJeiHelpers();
            IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
            IPlatformFluidHelper platformFluidHelper = jeiHelpers.getPlatformFluidHelper();
            registration.addRecipeCategories(new IRecipeCategory[]{new DebugRecipeCategory(guiHelper, platformFluidHelper), new DebugFocusRecipeCategory(guiHelper, platformFluidHelper), new LegacyDebugRecipeCategory(guiHelper, platformFluidHelper)});
        }
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ingredientManager = registration.getIngredientManager();
        if (ClientConfig.getInstance().isDebugModeEnabled()) {
            registration.addItemStackInfo(List.of(new ItemStack((ItemLike)Blocks.OAK_DOOR), new ItemStack((ItemLike)Blocks.SPRUCE_DOOR), new ItemStack((ItemLike)Blocks.BIRCH_DOOR), new ItemStack((ItemLike)Blocks.JUNGLE_DOOR), new ItemStack((ItemLike)Blocks.ACACIA_DOOR), new ItemStack((ItemLike)Blocks.DARK_OAK_DOOR)), new Component[]{new TranslatableComponent("description.jei.wooden.door.1"), new TranslatableComponent("description.jei.wooden.door.2"), new TranslatableComponent("description.jei.wooden.door.3")});
            IJeiHelpers jeiHelpers = registration.getJeiHelpers();
            IPlatformFluidHelper platformFluidHelper = jeiHelpers.getPlatformFluidHelper();
            this.registerFluidRecipes(registration, platformFluidHelper);
            registration.addIngredientInfo((Object)new DebugIngredient(1), DebugIngredient.TYPE, new Component[]{new TextComponent("debug")});
            registration.addIngredientInfo((Object)new DebugIngredient(2), DebugIngredient.TYPE, new Component[]{new TextComponent("debug colored").withStyle(ChatFormatting.AQUA), new TextComponent("debug\\nSplit and colored").withStyle(ChatFormatting.LIGHT_PURPLE), new TranslatableComponent("description.jei.debug.formatting.1", new Object[]{"various"}), new TranslatableComponent("description.jei.debug.formatting.1", new Object[]{"various\\nsplit"}), new TranslatableComponent("description.jei.debug.formatting.1", new Object[]{new TextComponent("various colored").withStyle(ChatFormatting.RED)}), new TranslatableComponent("description.jei.debug.formatting.1", new Object[]{new TextComponent("various\\nsplit colored").withStyle(ChatFormatting.DARK_AQUA)}), new TranslatableComponent("description.jei.debug.formatting.1", new Object[]{"\\nSplitting at the start"}), new TranslatableComponent("description.jei.debug.formatting.1", new Object[]{"various all colored"}).withStyle(ChatFormatting.RED), new TranslatableComponent("description.jei.debug.formatting.1", new Object[]{new TranslatableComponent("description.jei.debug.formatting.3", new Object[]{"various"}).withStyle(ChatFormatting.DARK_AQUA)}), new TranslatableComponent("description.jei.debug.formatting.2", new Object[]{new TextComponent("multiple").withStyle(ChatFormatting.GOLD).withStyle(ChatFormatting.ITALIC), new TextComponent("various").withStyle(ChatFormatting.RED)}).withStyle(ChatFormatting.BLUE), new TranslatableComponent("description.jei.debug.formatting.1", new Object[]{new TranslatableComponent("description.jei.debug.formatting.3", new Object[]{new TranslatableComponent("description.jei.debug.formatting.2", new Object[]{new TextComponent("multiple").withStyle(ChatFormatting.GOLD).withStyle(ChatFormatting.ITALIC), new TextComponent("various").withStyle(ChatFormatting.RED)}).withStyle(ChatFormatting.DARK_AQUA)})})});
            registration.addRecipes(DebugRecipeCategory.TYPE, List.of(new DebugRecipe(), new DebugRecipe()));
            registration.addRecipes(DebugFocusRecipeCategory.TYPE, List.of(new DebugRecipe()));
            registration.addRecipes(List.of(new DebugRecipe(), new DebugRecipe()), LegacyDebugRecipeCategory.UID);
        }
    }

    private <T> void registerFluidRecipes(IRecipeRegistration registration, IPlatformFluidHelper<T> platformFluidHelper) {
        long bucketVolume = platformFluidHelper.bucketVolume();
        Object fluidIngredient = platformFluidHelper.create((Fluid)Fluids.WATER, bucketVolume, null);
        registration.addIngredientInfo(fluidIngredient, (IIngredientType)platformFluidHelper.getFluidIngredientType(), new Component[]{new TextComponent("water")});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        if (ClientConfig.getInstance().isDebugModeEnabled()) {
            registration.addGuiContainerHandler(BrewingStandScreen.class, (IGuiContainerHandler)new IGuiContainerHandler<BrewingStandScreen>(){

                public List<Rect2i> getGuiExtraAreas(BrewingStandScreen containerScreen) {
                    int widthMovement = (int)(System.currentTimeMillis() / 100L % 100L);
                    int size = 25 + widthMovement;
                    IPlatformScreenHelper screenHelper = Services.PLATFORM.getScreenHelper();
                    int guiLeft = screenHelper.getGuiLeft((AbstractContainerScreen<?>)containerScreen);
                    int xSize = screenHelper.getXSize((AbstractContainerScreen<?>)containerScreen);
                    int guiTop = screenHelper.getGuiTop((AbstractContainerScreen<?>)containerScreen);
                    return List.of(new Rect2i(guiLeft + xSize, guiTop + 40, size, size));
                }

                @Nullable
                public Object getIngredientUnderMouse(BrewingStandScreen containerScreen, double mouseX, double mouseY) {
                    if (mouseX < 10.0 && mouseY < 10.0) {
                        IPlatformFluidHelperInternal<?> fluidHelper = Services.PLATFORM.getFluidHelper();
                        long bucketVolume = fluidHelper.bucketVolume();
                        return fluidHelper.create((Fluid)Fluids.WATER, bucketVolume, null);
                    }
                    return null;
                }
            });
            registration.addGhostIngredientHandler(BrewingStandScreen.class, new DebugGhostIngredientHandler());
        }
    }

    public <T> void registerFluidSubtypes(ISubtypeRegistration registration, IPlatformFluidHelper<T> platformFluidHelper) {
        FlowingFluid water = Fluids.WATER;
        IIngredientTypeWithSubtypes ingredientType = platformFluidHelper.getFluidIngredientType();
        FluidSubtypeHandlerTest subtype = new FluidSubtypeHandlerTest(ingredientType);
        registration.registerSubtypeInterpreter(ingredientType, (Object)water, subtype);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        if (ClientConfig.getInstance().isDebugModeEnabled()) {
            IPlatformFluidHelperInternal<?> fluidHelper = Services.PLATFORM.getFluidHelper();
            this.registerRecipeCatalysts(registration, fluidHelper);
        }
    }

    private <T> void registerRecipeCatalysts(IRecipeCatalystRegistration registration, IPlatformFluidHelper<T> fluidHelper) {
        long bucketVolume = fluidHelper.bucketVolume();
        registration.addRecipeCatalyst(DebugIngredient.TYPE, (Object)new DebugIngredient(7), new RecipeType[]{DebugRecipeCategory.TYPE});
        registration.addRecipeCatalyst((IIngredientType)fluidHelper.getFluidIngredientType(), fluidHelper.create((Fluid)Fluids.WATER, bucketVolume, null), new RecipeType[]{DebugRecipeCategory.TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Items.STICK), new RecipeType[]{DebugRecipeCategory.TYPE});
        IPlatformRegistry registry = Services.PLATFORM.getRegistry(Registry.ITEM_REGISTRY);
        registry.getValues().limit(30L).forEach(item -> {
            ItemStack catalystIngredient = new ItemStack((ItemLike)item);
            if (!catalystIngredient.isEmpty()) {
                registration.addRecipeCatalyst(catalystIngredient, new RecipeType[]{DebugRecipeCategory.TYPE});
            }
        });
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        JeiDebugPlugin.jeiRuntime = jeiRuntime;
        if (ClientConfig.getInstance().isDebugModeEnabled()) {
            ErrorUtil.assertMainThread();
            IIngredientManager ingredientManager = jeiRuntime.getIngredientManager();
            ingredientManager.addIngredientsAtRuntime(DebugIngredient.TYPE, DebugIngredientListFactory.create());
        }
    }
}

