/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.plugins.vanilla.crafting;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.common.plugins.vanilla.crafting.CategoryRecipeValidator;
import mezz.jei.common.util.ErrorUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.item.crafting.UpgradeRecipe;

public final class VanillaRecipes {
    private final RecipeManager recipeManager;

    public VanillaRecipes() {
        Minecraft minecraft = Minecraft.getInstance();
        ErrorUtil.checkNotNull(minecraft, "minecraft");
        ClientLevel world = minecraft.level;
        ErrorUtil.checkNotNull(world, "minecraft world");
        this.recipeManager = world.getRecipeManager();
    }

    public Map<Boolean, List<CraftingRecipe>> getCraftingRecipes(IRecipeCategory<CraftingRecipe> craftingCategory) {
        CategoryRecipeValidator<CraftingRecipe> validator = new CategoryRecipeValidator<CraftingRecipe>(craftingCategory, 9);
        return this.recipeManager.getAllRecipesFor(RecipeType.CRAFTING).stream().filter(validator::isRecipeValid).collect(Collectors.partitioningBy(validator::isRecipeHandled));
    }

    public List<StonecutterRecipe> getStonecuttingRecipes(IRecipeCategory<StonecutterRecipe> stonecuttingCategory) {
        CategoryRecipeValidator<StonecutterRecipe> validator = new CategoryRecipeValidator<StonecutterRecipe>(stonecuttingCategory, 1);
        return VanillaRecipes.getValidHandledRecipes(this.recipeManager, RecipeType.STONECUTTING, validator);
    }

    public List<SmeltingRecipe> getFurnaceRecipes(IRecipeCategory<SmeltingRecipe> furnaceCategory) {
        CategoryRecipeValidator<SmeltingRecipe> validator = new CategoryRecipeValidator<SmeltingRecipe>(furnaceCategory, 1);
        return VanillaRecipes.getValidHandledRecipes(this.recipeManager, RecipeType.SMELTING, validator);
    }

    public List<SmokingRecipe> getSmokingRecipes(IRecipeCategory<SmokingRecipe> smokingCategory) {
        CategoryRecipeValidator<SmokingRecipe> validator = new CategoryRecipeValidator<SmokingRecipe>(smokingCategory, 1);
        return VanillaRecipes.getValidHandledRecipes(this.recipeManager, RecipeType.SMOKING, validator);
    }

    public List<BlastingRecipe> getBlastingRecipes(IRecipeCategory<BlastingRecipe> blastingCategory) {
        CategoryRecipeValidator<BlastingRecipe> validator = new CategoryRecipeValidator<BlastingRecipe>(blastingCategory, 1);
        return VanillaRecipes.getValidHandledRecipes(this.recipeManager, RecipeType.BLASTING, validator);
    }

    public List<CampfireCookingRecipe> getCampfireCookingRecipes(IRecipeCategory<CampfireCookingRecipe> campfireCategory) {
        CategoryRecipeValidator<CampfireCookingRecipe> validator = new CategoryRecipeValidator<CampfireCookingRecipe>(campfireCategory, 1);
        return VanillaRecipes.getValidHandledRecipes(this.recipeManager, RecipeType.CAMPFIRE_COOKING, validator);
    }

    public List<UpgradeRecipe> getSmithingRecipes(IRecipeCategory<UpgradeRecipe> smithingCategory) {
        CategoryRecipeValidator<UpgradeRecipe> validator = new CategoryRecipeValidator<UpgradeRecipe>(smithingCategory, 0);
        return VanillaRecipes.getValidHandledRecipes(this.recipeManager, RecipeType.SMITHING, validator);
    }

    private static <C extends Container, T extends Recipe<C>> List<T> getValidHandledRecipes(RecipeManager recipeManager, RecipeType<T> recipeType, CategoryRecipeValidator<T> validator) {
        return recipeManager.getAllRecipesFor(recipeType).stream().filter(r -> validator.isRecipeValid(r) && validator.isRecipeHandled(r)).toList();
    }
}

