/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.plugins.debug;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IBookmarkOverlay;
import mezz.jei.api.runtime.IIngredientFilter;
import mezz.jei.api.runtime.IIngredientListOverlay;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.plugins.debug.DebugRecipe;
import mezz.jei.common.plugins.debug.JeiDebugPlugin;
import mezz.jei.common.plugins.jei.ingredients.DebugIngredient;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class LegacyDebugRecipeCategory<F>
implements IRecipeCategory<DebugRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("jei", "legacy_debug");
    public static final int RECIPE_WIDTH = 160;
    public static final int RECIPE_HEIGHT = 60;
    private final IDrawable background;
    private final IPlatformFluidHelper<F> platformFluidHelper;
    private final Component localizedName;
    private final IDrawable tankBackground;
    private final IDrawable tankOverlay;
    private final IDrawable item;
    private boolean hiddenRecipes;

    public LegacyDebugRecipeCategory(IGuiHelper guiHelper, IPlatformFluidHelper<F> platformFluidHelper) {
        this.background = guiHelper.createBlankDrawable(160, 60);
        this.platformFluidHelper = platformFluidHelper;
        this.localizedName = new TextComponent("debug");
        ResourceLocation backgroundTexture = new ResourceLocation("jei", "textures/gui/debug.png");
        this.tankBackground = guiHelper.drawableBuilder(backgroundTexture, 220, 196, 18, 60).addPadding(-1, -1, -1, -1).build();
        this.tankOverlay = guiHelper.drawableBuilder(backgroundTexture, 238, 196, 18, 60).addPadding(-1, -1, -1, -1).build();
        this.item = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Items.ACACIA_LEAVES));
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends DebugRecipe> getRecipeClass() {
        return DebugRecipe.class;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        Textures textures = Internal.getTextures();
        return textures.getConfigButtonIcon();
    }

    public void setIngredients(DebugRecipe recipe, IIngredients ingredients) {
        long bucketVolume = this.platformFluidHelper.bucketVolume();
        IIngredientTypeWithSubtypes fluidType = this.platformFluidHelper.getFluidIngredientType();
        Object water = this.platformFluidHelper.create((Fluid)Fluids.WATER, (long)((int)((1.0 + Math.random()) * (double)bucketVolume)));
        Object lava = this.platformFluidHelper.create((Fluid)Fluids.LAVA, (long)((int)((1.0 + Math.random()) * (double)bucketVolume)));
        ingredients.setInputs((IIngredientType)fluidType, List.of(water, lava));
        ingredients.setInput((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Items.STICK));
        ingredients.setInputLists(DebugIngredient.TYPE, List.of(List.of(new DebugIngredient(0), new DebugIngredient(1))));
        ingredients.setOutputs(DebugIngredient.TYPE, List.of(new DebugIngredient(2), new DebugIngredient(3)));
    }

    public void draw(DebugRecipe recipe, PoseStack poseStack, double mouseX, double mouseY) {
        IJeiRuntime runtime = JeiDebugPlugin.jeiRuntime;
        if (runtime != null) {
            this.item.draw(poseStack, 50, 20);
            IIngredientFilter ingredientFilter = runtime.getIngredientFilter();
            Minecraft minecraft = Minecraft.getInstance();
            minecraft.font.draw(poseStack, ingredientFilter.getFilterText(), 20.0f, 52.0f, 0);
            IIngredientListOverlay ingredientListOverlay = runtime.getIngredientListOverlay();
            IIngredientManager ingredientManager = runtime.getIngredientManager();
            Collection ingredientTypes = ingredientManager.getRegisteredIngredientTypes();
            for (IIngredientType ingredientType : ingredientTypes) {
                Object ingredientUnderMouse = ingredientListOverlay.getIngredientUnderMouse(ingredientType);
                if (ingredientUnderMouse != null) {
                    LegacyDebugRecipeCategory.drawIngredientName(minecraft, poseStack, ingredientUnderMouse);
                    break;
                }
                IBookmarkOverlay bookmarkOverlay = runtime.getBookmarkOverlay();
                ingredientUnderMouse = bookmarkOverlay.getIngredientUnderMouse(ingredientType);
                if (ingredientUnderMouse == null) continue;
                LegacyDebugRecipeCategory.drawIngredientName(minecraft, poseStack, ingredientUnderMouse);
                break;
            }
        }
        Button button = recipe.getButton();
        button.render(poseStack, (int)mouseX, (int)mouseY, 0.0f);
    }

    private static <T> void drawIngredientName(Minecraft minecraft, PoseStack poseStack, T ingredient) {
        IIngredientManager ingredientManager = JeiDebugPlugin.ingredientManager;
        if (ingredientManager != null) {
            IIngredientHelper ingredientHelper = ingredientManager.getIngredientHelper(ingredient);
            String jeiUid = ingredientHelper.getUniqueId(ingredient, UidContext.Ingredient);
            minecraft.font.draw(poseStack, jeiUid, 50.0f, 52.0f, 0);
        }
    }

    public void setRecipe(IRecipeLayout recipeLayout, DebugRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            if (input) {
                tooltip.add(new TextComponent(slotIndex + " Input itemStack"));
            } else {
                tooltip.add(new TextComponent(slotIndex + " Output itemStack"));
            }
        });
        guiItemStacks.init(0, false, 70, 0);
        guiItemStacks.init(1, true, 110, 0);
        guiItemStacks.set(0, new ItemStack((ItemLike)Items.WATER_BUCKET));
        guiItemStacks.set(1, Arrays.asList(new ItemStack((ItemLike)Items.LAVA_BUCKET), null));
        IGuiIngredientGroup debugIngredientsGroup = recipeLayout.getIngredientsGroup(DebugIngredient.TYPE);
        debugIngredientsGroup.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            if (input) {
                tooltip.add(new TextComponent(slotIndex + " Input DebugIngredient"));
            } else {
                tooltip.add(new TextComponent(slotIndex + " Output DebugIngredient"));
            }
        });
        debugIngredientsGroup.init(0, true, 40, 0);
        debugIngredientsGroup.init(1, false, 40, 16);
        debugIngredientsGroup.init(2, false, 40, 32);
        debugIngredientsGroup.set(ingredients);
    }

    public List<Component> getTooltipStrings(DebugRecipe recipe, double mouseX, double mouseY) {
        ArrayList<Component> tooltipStrings = new ArrayList<Component>();
        tooltipStrings.add((Component)new TextComponent("Debug Recipe Category Tooltip is very long and going to wrap").withStyle(ChatFormatting.GOLD));
        if (recipe.checkHover(mouseX, mouseY)) {
            tooltipStrings.add((Component)new TextComponent("button tooltip!"));
        } else {
            TextComponent debug = new TextComponent("tooltip debug");
            tooltipStrings.add((Component)debug.withStyle(ChatFormatting.BOLD));
        }
        tooltipStrings.add((Component)new TextComponent(mouseX + ", " + mouseY));
        return tooltipStrings;
    }

    public boolean handleInput(DebugRecipe recipe, double mouseX, double mouseY, InputConstants.Key input) {
        if (input.getType() != InputConstants.Type.MOUSE) {
            return false;
        }
        Button button = recipe.getButton();
        int mouseButton = input.getValue();
        if (mouseButton == 0 && button.mouseClicked(mouseX, mouseY, mouseButton)) {
            IJeiRuntime runtime;
            Minecraft minecraft = Minecraft.getInstance();
            LocalPlayer player = minecraft.player;
            if (player != null) {
                InventoryScreen screen = new InventoryScreen((Player)player);
                minecraft.setScreen((Screen)screen);
            }
            if ((runtime = JeiDebugPlugin.jeiRuntime) != null) {
                IIngredientFilter ingredientFilter = runtime.getIngredientFilter();
                String filterText = ingredientFilter.getFilterText();
                ingredientFilter.setFilterText(filterText + " test");
                IRecipeManager recipeManager = runtime.getRecipeManager();
                if (!this.hiddenRecipes) {
                    recipeManager.hideRecipeCategory(VanillaRecipeCategoryUid.CRAFTING);
                    this.hiddenRecipes = true;
                } else {
                    recipeManager.unhideRecipeCategory(VanillaRecipeCategoryUid.CRAFTING);
                    this.hiddenRecipes = false;
                }
            }
            return true;
        }
        return false;
    }
}

